/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.ArrayListUtil;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;

public final class TableLineGrouper {
    private SortedMap map = new TreeMap(ArrayListUtil.integerComparator());
    private final ApproximateMatcher matcher = new ApproximateMatcher(120);

    public TableLineGrouper() {
        this.matcher.setIgnoreCase(true);
        this.matcher.setIgnoreWhitespace(true);
        this.matcher.setCompareBackwards(true);
    }

    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    public synchronized void clear() {
        this.map.clear();
    }

    private int matchHelper(List list, TableLine tableLine) {
        Assert.that(list != null, "Trying to match null list");
        Assert.that(tableLine != null, "Trying to match null line");
        int n = 0;
        while (n < list.size()) {
            TableLine tableLine2 = (TableLine)list.get(n);
            int n2 = tableLine2.match(tableLine, this.matcher);
            if (n2 == 0) {
                return n;
            }
            if (n2 == 2) {
                return -2;
            }
            ++n;
        }
        return -1;
    }

    public synchronized TableLine match(TableLine tableLine) {
        Object object;
        Integer n = tableLine.size;
        Iterator iterator = this.map.tailMap(n).values().iterator();
        while (iterator.hasNext()) {
            object = (List)iterator.next();
            int n2 = this.matchHelper((List)object, tableLine);
            if (n2 >= 0) {
                return (TableLine)object.get(n2);
            }
            if (n2 == -2) break;
        }
        object = this.map.headMap(n);
        while (true) {
            Integer n3;
            try {
                n3 = (Integer)object.lastKey();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            List list = (List)object.get(n3);
            int n4 = this.matchHelper(list, tableLine);
            if (n4 >= 0) {
                return (TableLine)list.get(n4);
            }
            if (n4 == -2) break;
            object = object.headMap(n3);
        }
        return null;
    }

    public synchronized void add(TableLine tableLine) {
        Integer n = tableLine.size;
        List list = (List)this.map.get(n);
        if (list == null) {
            list = new LinkedList();
            list.add(tableLine);
            this.map.put(n, list);
        } else {
            list.add(tableLine);
        }
    }
}

