/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.TableColumnFilter;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.sun.java.util.collections.ArrayList;

class TableRowFilter
extends TableColumnFilter {
    private TableLineFilter filter;
    private ArrayList map = new ArrayList();
    private int numRows = 0;

    public TableRowFilter(TableLine tableLine, boolean bl, ResultPanel resultPanel) {
        super(tableLine, bl, resultPanel);
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            this.addSchema(limeXMLSchemaRepository.getSchema(stringArray[n]));
            ++n;
        }
    }

    public TableRowFilter(TableLine tableLine, boolean bl, TableLineFilter tableLineFilter, ResultPanel resultPanel) {
        this(tableLine, bl, resultPanel);
        this.filter = tableLineFilter;
    }

    public int getChildCount(Object object) {
        if (object == this.getRoot()) {
            return this.map.size();
        }
        return super.getChildCount(object);
    }

    public Object getChild(Object object, int n) {
        this.debug("getting child initial i= " + n);
        if (object == this.getRoot()) {
            this.debug("Given node is root");
            n = (Integer)this.map.get(n);
        }
        this.debug("getting child final i= " + n);
        return super.getChild(object, n);
    }

    public void setFilter(TableLineFilter tableLineFilter) {
        this.filter = tableLineFilter;
        this.rebuildMap();
    }

    void addLine(TableLine tableLine, TableLine tableLine2, boolean bl) {
        super.addLine(tableLine, tableLine2, bl);
        if (this.allow(tableLine)) {
            ++this.numRows;
            this.debug("line added");
            if (bl) {
                if (tableLine2 == null) {
                    int n = this.getRowCount() - 1;
                    this.map.add(new Integer(n));
                    TableLine tableLine3 = (TableLine)this.getRoot();
                    this.fireTreeNodesInserted(this, new Object[]{tableLine3}, new int[]{this.map.size() - 1}, new Object[]{tableLine});
                } else {
                    this.fireTreeNodesInserted(this, new Object[]{this.root, tableLine2}, new int[]{tableLine2.children.size() - 1}, new Object[]{tableLine});
                }
            } else {
                int n = this.getRowCount() - 1;
                this.map.add(new Integer(n));
                TableLine tableLine4 = (TableLine)this.getRoot();
                this.fireTreeNodesInserted(this, new Object[]{tableLine4}, new int[]{this.map.size() - 1}, new Object[]{tableLine});
            }
        } else {
            this.debug("line not added");
        }
    }

    void group() {
        super.group();
        this.rebuildMap();
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    void ungroup() {
        super.ungroup();
        this.rebuildMap();
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    void sort(int n, boolean bl) {
        super.sort(n, bl);
        this.rebuildMap();
        this.fireTreeStructureChanged(this, new Object[]{this.root}, null, null);
    }

    int numLeaves() {
        return this.numRows;
    }

    private boolean allow(TableLine tableLine) {
        if (this.filter == null) {
            return true;
        }
        return true;
    }

    private void rebuildMap() {
        this.map.clear();
        int n = 0;
        while (n < this.getRowCount()) {
            if (this.allow((TableLine)this.getRow(n))) {
                this.map.add(new Integer(n));
            }
            ++n;
        }
    }

    private void debug(String string) {
        boolean bl = false;
        if (bl) {
            System.out.println(string);
        }
    }
}

