/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.statistics.StatisticsButtonPanel;
import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneImpl;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneManager;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneParent;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeManager;
import com.limegroup.gnutella.gui.statistics.VisibleStatsPane;
import com.limegroup.gnutella.gui.statistics.panes.AdvancedStats;
import com.limegroup.gnutella.gui.statistics.panes.BandwidthStats;
import com.limegroup.gnutella.gui.statistics.panes.ConnectionAttemptsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.FilteredMessagesPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.FlowControl;
import com.limegroup.gnutella.gui.statistics.panes.FlowControlBytes;
import com.limegroup.gnutella.gui.statistics.panes.HTTPRequestsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.HitHops;
import com.limegroup.gnutella.gui.statistics.panes.HitHopsBytes;
import com.limegroup.gnutella.gui.statistics.panes.HitTTL;
import com.limegroup.gnutella.gui.statistics.panes.HitTTLBytes;
import com.limegroup.gnutella.gui.statistics.panes.NetStats;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.limegroup.gnutella.gui.statistics.panes.QueryHops;
import com.limegroup.gnutella.gui.statistics.panes.QueryHopsBytes;
import com.limegroup.gnutella.gui.statistics.panes.QueryReplyRouteErrors;
import com.limegroup.gnutella.gui.statistics.panes.QueryTTL;
import com.limegroup.gnutella.gui.statistics.panes.QueryTTLBytes;
import com.limegroup.gnutella.gui.statistics.panes.RouteErrorsPaneItem;
import com.limegroup.gnutella.gui.statistics.panes.TCPAverageMessageSize;
import com.limegroup.gnutella.gui.statistics.panes.TCPBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.TCPDuplicateQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPDuplicateQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeAverageMessageSize;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPings;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPongs;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeReceivedQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPings;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPongs;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueries;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.TCPLimeSentQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.TCPMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.TCPUDPBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPUDPBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.TCPUDPMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.TCPUDPMessagesSent;
import com.limegroup.gnutella.gui.statistics.panes.TotalDownstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.TotalReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.TotalReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.TotalSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.TotalSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.TotalUpstreamBandwidth;
import com.limegroup.gnutella.gui.statistics.panes.UDPBytesReceived;
import com.limegroup.gnutella.gui.statistics.panes.UDPBytesSent;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedMessages;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPings;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPongs;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueries;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeReceivedQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentMessages;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPings;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPingsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPongs;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPongsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPushRequests;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentPushRequestsBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueries;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueriesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueryReplies;
import com.limegroup.gnutella.gui.statistics.panes.UDPLimeSentQueryRepliesBytes;
import com.limegroup.gnutella.gui.statistics.panes.UDPMessagesReceived;
import com.limegroup.gnutella.gui.statistics.panes.UDPMessagesSent;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public final class StatisticsConstructor {
    private static final JDialog DIALOG = new JDialog(GUIMediator.getAppFrame(), GUIMediator.getStringResource("STATS_TITLE"), false);
    private static final int STATISTICS_WIDTH = 660;
    private static final int STATISTICS_HEIGHT = 460;
    private static StatisticsTreeManager _treeManager;
    private static StatisticsPaneManager _paneManager;
    private static final String ADVANCED_KEY = "STATS_ADVANCED_PANE_TITLE";
    private static final JPanel MAIN_PANEL;
    private static final JSplitPane SPLIT_PANE;

    public StatisticsConstructor(StatisticsTreeManager statisticsTreeManager, StatisticsPaneManager statisticsPaneManager) {
        VisibleStatsPane visibleStatsPane;
        _treeManager = statisticsTreeManager;
        _paneManager = statisticsPaneManager;
        ((Component)DIALOG).setSize(660, 460);
        Box box = new Box(0);
        Component component = _treeManager.getComponent();
        JComponent jComponent = _paneManager.getComponent();
        SPLIT_PANE.setLeftComponent(component);
        SPLIT_PANE.setRightComponent(jComponent);
        box.add(SPLIT_PANE);
        MAIN_PANEL.add(box);
        MAIN_PANEL.add(Box.createVerticalStrut(17));
        MAIN_PANEL.add(new StatisticsButtonPanel().getComponent());
        DIALOG.getContentPane().add(MAIN_PANEL);
        DIALOG.addComponentListener(new PaneAdapter());
        if (!CommonUtils.isJava118()) {
            visibleStatsPane = new VisibleStatsPane("STATS_BANDWIDTH_PANE_TITLE");
            visibleStatsPane.add(new BandwidthStats());
            StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", visibleStatsPane);
            StatisticsConstructor.addStatisticPane("STATS_BANDWIDTH_PANE_TITLE", "TOTAL_UPSTREAM_BANDWIDTH", new TotalUpstreamBandwidth("TOTAL_UPSTREAM_BANDWIDTH"));
            StatisticsConstructor.addStatisticPane("STATS_BANDWIDTH_PANE_TITLE", "TOTAL_DOWNSTREAM_BANDWIDTH", new TotalDownstreamBandwidth("TOTAL_DOWNSTREAM_BANDWIDTH"));
        }
        visibleStatsPane = new VisibleStatsPane("STATS_NET_PANE_TITLE");
        visibleStatsPane.add(new NetStats());
        StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", visibleStatsPane);
        if (!CommonUtils.isJava118()) {
            VisibleStatsPane visibleStatsPane2 = new VisibleStatsPane(ADVANCED_KEY);
            visibleStatsPane2.add(new AdvancedStats());
            StatisticsConstructor.addGroupTreeNode("STATISTICS_ROOT_NODE", visibleStatsPane2);
        }
        _treeManager.getTree().setSelectionRow(0);
    }

    static void setAdvancedStatsVisible(boolean bl) {
        if (bl) {
            _treeManager.advancedSize();
            SPLIT_PANE.setDividerLocation(200);
            StatisticsConstructor.makeStatsVisible();
            ((Component)DIALOG).setSize(735, 460);
        } else {
            _treeManager.defaultSize();
            SPLIT_PANE.setDividerLocation(125);
            _treeManager.removeAllChildren(ADVANCED_KEY);
            ((Component)DIALOG).setSize(660, 460);
        }
    }

    private static void makeStatsVisible() {
        StatisticsConstructor.addGroupTreeNode(ADVANCED_KEY, "GNUTELLA_MESSAGES");
        StatisticsConstructor.addReceivedStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addSentStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addFlowControlStats("GNUTELLA_MESSAGES");
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "ROUTE_ERRORS", new RouteErrorsPaneItem("ROUTE_ERRORS"));
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "QUERY_REPLY_ROUTE_ERRORS", new QueryReplyRouteErrors("QUERY_REPLY_ROUTE_ERRORS"));
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "FILTERED_MESSAGES", new FilteredMessagesPaneItem("FILTERED_MESSAGES"));
        StatisticsConstructor.addStatisticPane("GNUTELLA_MESSAGES", "TOTAL_CONNECTION_ATTEMPTS", new ConnectionAttemptsPaneItem("TOTAL_CONNECTION_ATTEMPTS"));
        StatisticsConstructor.addStatisticPane(ADVANCED_KEY, "TOTAL_HTTP_REQUESTS", new HTTPRequestsPaneItem("TOTAL_HTTP_REQUESTS"));
    }

    private static void addFlowControlStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "FLOW_CONTROLLED_MESSAGES");
        StatisticsConstructor.addStatisticPane("FLOW_CONTROLLED_MESSAGES", "FLOW_CONTROL", new FlowControl("FLOW_CONTROL"));
        StatisticsConstructor.addStatisticPane("FLOW_CONTROLLED_MESSAGES", "FLOW_CONTROL_BYTES", new FlowControlBytes("FLOW_CONTROL_BYTES"));
    }

    private static void addReceivedStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedNumberStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedBytesStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedAverageMessageSizeStats("RECEIVED_MESSAGES");
        StatisticsConstructor.addReceivedLimeStats("RECEIVED_MESSAGES");
    }

    private static void addSentStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "SENT_MESSAGES");
        StatisticsConstructor.addSentNumberStats("SENT_MESSAGES");
        StatisticsConstructor.addSentBytesStats("SENT_MESSAGES");
        StatisticsConstructor.addSentLimeStats("SENT_MESSAGES");
    }

    private static void addReceivedNumberStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_MESSAGES", new TotalReceivedMessages("TOTAL_RECEIVED_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_TCP_MESSAGES", new TCPMessagesReceived("TOTAL_RECEIVED_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "TOTAL_RECEIVED_UDP_MESSAGES", new UDPMessagesReceived("TOTAL_RECEIVED_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_NUMBER", "RECEIVED_TCP_UDP", new TCPUDPMessagesReceived("RECEIVED_TCP_UDP"));
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_NUMBER", "RECEIVED_QUERY_REQUESTS");
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "QUERY_REQUEST_HOPS", new QueryHops("QUERY_REQUEST_HOPS"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "QUERY_REQUEST_TTL", new QueryTTL("QUERY_REQUEST_TTL"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS", "DUPLICATE_RECEIVED_TCP_QUERIES", new TCPDuplicateQueries("DUPLICATE_RECEIVED_TCP_QUERIES"));
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_NUMBER", "RECEIVED_QUERY_REPLIES");
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES", "QUERY_REPLY_HOPS", new HitHops("QUERY_REPLY_HOPS"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES", "QUERY_REPLY_TTL", new HitTTL("QUERY_REPLY_TTL"));
    }

    private static void addReceivedBytesStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_MESSAGES", new TotalReceivedBytes("TOTAL_RECEIVED_BYTES_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_TCP_MESSAGES", new TCPBytesReceived("TOTAL_RECEIVED_BYTES_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "TOTAL_RECEIVED_BYTES_UDP_MESSAGES", new UDPBytesReceived("TOTAL_RECEIVED_BYTES_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_MESSAGE_BYTES", "RECEIVED_BYTES_TCP_UDP", new TCPUDPBytesReceived("RECEIVED_BYTES_TCP_UDP"));
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_BYTES", "RECEIVED_QUERY_REQUESTS_BYTES");
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "QUERY_REQUEST_HOPS_BYTES", new QueryHopsBytes("QUERY_REQUEST_HOPS_BYTES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "QUERY_REQUEST_TTL_BYTES", new QueryTTLBytes("QUERY_REQUEST_TTL_BYTES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REQUESTS_BYTES", "DUPLICATE_RECEIVED_BYTES_TCP_QUERIES", new TCPDuplicateQueriesBytes("DUPLICATE_RECEIVED_BYTES_TCP_QUERIES"));
        StatisticsConstructor.addGroupTreeNode("RECEIVED_MESSAGE_BYTES", "RECEIVED_QUERY_REPLIES_BYTES");
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES_BYTES", "QUERY_REPLY_HOPS_BYTES", new HitHopsBytes("QUERY_REPLY_HOPS_BYTES"));
        StatisticsConstructor.addStatisticPane("RECEIVED_QUERY_REPLIES_BYTES", "QUERY_REPLY_TTL_BYTES", new HitTTLBytes("QUERY_REPLY_TTL_BYTES"));
    }

    private static void addReceivedLimeStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "RECEIVED_LIMEWIRE");
        StatisticsConstructor.addGroupTreeNode("RECEIVED_LIMEWIRE", "LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addReceivedLimeNumberStatsTCP("LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addReceivedLimeNumberStatsUDP("LIME_RECEIVED_MESSAGE_NUMBER");
        StatisticsConstructor.addGroupTreeNode("RECEIVED_LIMEWIRE", "LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedLimeBytesStatsTCP("LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedLimeBytesStatsUDP("LIME_RECEIVED_MESSAGE_BYTES");
        StatisticsConstructor.addReceivedAverageLimeMessageSizeStats("RECEIVED_LIMEWIRE");
    }

    private static void addReceivedLimeNumberStatsTCP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_RECEIVED_TCP");
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_MESSAGES", new TCPLimeReceivedMessages("LIME_RECEIVED_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PING_REQUESTS", new TCPLimeReceivedPings("LIME_RECEIVED_TCP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PING_REPLIES", new TCPLimeReceivedPongs("LIME_RECEIVED_TCP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_QUERIES", new TCPLimeReceivedQueries("LIME_RECEIVED_TCP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_QUERY_REPLIES", new TCPLimeReceivedQueryReplies("LIME_RECEIVED_TCP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP", "LIME_RECEIVED_TCP_PUSH_REQUESTS", new TCPLimeReceivedPushRequests("LIME_RECEIVED_TCP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeNumberStatsUDP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_RECEIVED_UDP");
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_MESSAGES", new UDPLimeReceivedMessages("LIME_RECEIVED_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PING_REQUESTS", new UDPLimeReceivedPings("LIME_RECEIVED_UDP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PING_REPLIES", new UDPLimeReceivedPongs("LIME_RECEIVED_UDP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_QUERIES", new UDPLimeReceivedQueries("LIME_RECEIVED_UDP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_QUERY_REPLIES", new UDPLimeReceivedQueryReplies("LIME_RECEIVED_UDP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP", "LIME_RECEIVED_UDP_PUSH_REQUESTS", new UDPLimeReceivedPushRequests("LIME_RECEIVED_UDP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeBytesStatsTCP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_RECEIVED_TCP_BYTES");
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_MESSAGES", new TCPLimeReceivedBytes("LIME_RECEIVED_BYTES_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PING_REQUESTS", new TCPLimeReceivedPingsBytes("LIME_RECEIVED_BYTES_TCP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PING_REPLIES", new TCPLimeReceivedPongsBytes("LIME_RECEIVED_BYTES_TCP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_QUERIES", new TCPLimeReceivedQueriesBytes("LIME_RECEIVED_BYTES_TCP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_QUERY_REPLIES", new TCPLimeReceivedQueryRepliesBytes("LIME_RECEIVED_BYTES_TCP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_TCP_BYTES", "LIME_RECEIVED_BYTES_TCP_PUSH_REQUESTS", new TCPLimeReceivedPushRequestsBytes("LIME_RECEIVED_BYTES_TCP_PUSH_REQUESTS"));
    }

    private static void addReceivedLimeBytesStatsUDP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_RECEIVED_UDP_BYTES");
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_MESSAGES", new UDPLimeReceivedBytes("LIME_RECEIVED_BYTES_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PING_REQUESTS", new UDPLimeReceivedPingsBytes("LIME_RECEIVED_BYTES_UDP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PING_REPLIES", new UDPLimeReceivedPongsBytes("LIME_RECEIVED_BYTES_UDP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_QUERIES", new UDPLimeReceivedQueriesBytes("LIME_RECEIVED_BYTES_UDP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_QUERY_REPLIES", new UDPLimeReceivedQueryRepliesBytes("LIME_RECEIVED_BYTES_UDP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_RECEIVED_UDP_BYTES", "LIME_RECEIVED_BYTES_UDP_PUSH_REQUESTS", new UDPLimeReceivedPushRequestsBytes("LIME_RECEIVED_BYTES_UDP_PUSH_REQUESTS"));
    }

    private static void addReceivedAverageMessageSizeStats(String string) {
        StatisticsConstructor.addStatisticPane(string, "RECEIVED_AVERAGE_MESSAGE_SIZE", new TCPAverageMessageSize("RECEIVED_AVERAGE_MESSAGE_SIZE"));
    }

    private static void addReceivedAverageLimeMessageSizeStats(String string) {
        StatisticsConstructor.addStatisticPane(string, "RECEIVED_AVERAGE_LIME_MESSAGE_SIZE", new TCPLimeAverageMessageSize("RECEIVED_AVERAGE_LIME_MESSAGE_SIZE"));
    }

    private static void addSentNumberStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "SENT_MESSAGE_NUMBER");
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_MESSAGES", new TotalSentMessages("TOTAL_SENT_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_TCP_MESSAGES", new TCPMessagesSent("TOTAL_SENT_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "TOTAL_SENT_UDP_MESSAGES", new UDPMessagesSent("TOTAL_SENT_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_NUMBER", "SENT_TCP_UDP", new TCPUDPMessagesSent("SENT_TCP_UDP"));
    }

    private static void addSentBytesStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "SENT_MESSAGE_BYTES");
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_MESSAGES", new TotalSentBytes("TOTAL_SENT_BYTES_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_TCP_MESSAGES", new TCPBytesSent("TOTAL_SENT_BYTES_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "TOTAL_SENT_BYTES_UDP_MESSAGES", new UDPBytesSent("TOTAL_SENT_BYTES_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("SENT_MESSAGE_BYTES", "SENT_BYTES_TCP_UDP", new TCPUDPBytesSent("SENT_BYTES_TCP_UDP"));
    }

    private static void addSentLimeStats(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "SENT_LIMEWIRE");
        StatisticsConstructor.addGroupTreeNode("SENT_LIMEWIRE", "LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addSentLimeNumberStatsTCP("LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addSentLimeNumberStatsUDP("LIME_SENT_MESSAGES_NUMBER");
        StatisticsConstructor.addGroupTreeNode("SENT_LIMEWIRE", "LIME_SENT_MESSAGES_BYTES");
        StatisticsConstructor.addSentLimeBytesStatsTCP("LIME_SENT_MESSAGES_BYTES");
        StatisticsConstructor.addSentLimeBytesStatsUDP("LIME_SENT_MESSAGES_BYTES");
    }

    private static void addSentLimeNumberStatsTCP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_SENT_TCP");
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_MESSAGES", new TCPLimeSentMessages("LIME_SENT_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PING_REQUESTS", new TCPLimeSentPings("LIME_SENT_TCP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PING_REPLIES", new TCPLimeSentPongs("LIME_SENT_TCP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_QUERIES", new TCPLimeSentQueries("LIME_SENT_TCP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_QUERY_REPLIES", new TCPLimeSentQueryReplies("LIME_SENT_TCP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP", "LIME_SENT_TCP_PUSH_REQUESTS", new TCPLimeSentPushRequests("LIME_SENT_TCP_PUSH_REQUESTS"));
    }

    private static void addSentLimeNumberStatsUDP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_SENT_UDP");
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_MESSAGES", new UDPLimeSentMessages("LIME_SENT_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PING_REQUESTS", new UDPLimeSentPings("LIME_SENT_UDP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PING_REPLIES", new UDPLimeSentPongs("LIME_SENT_UDP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_QUERIES", new UDPLimeSentQueries("LIME_SENT_UDP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_QUERY_REPLIES", new UDPLimeSentQueryReplies("LIME_SENT_UDP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP", "LIME_SENT_UDP_PUSH_REQUESTS", new UDPLimeSentPushRequests("LIME_SENT_UDP_PUSH_REQUESTS"));
    }

    private static void addSentLimeBytesStatsTCP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_SENT_TCP_BYTES");
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_MESSAGES", new TCPLimeSentBytes("LIME_SENT_BYTES_TCP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PING_REQUESTS", new TCPLimeSentPingsBytes("LIME_SENT_BYTES_TCP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PING_REPLIES", new TCPLimeSentPongsBytes("LIME_SENT_BYTES_TCP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_QUERIES", new TCPLimeSentQueriesBytes("LIME_SENT_BYTES_TCP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_QUERY_REPLIES", new TCPLimeSentQueryRepliesBytes("LIME_SENT_BYTES_TCP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_TCP_BYTES", "LIME_SENT_BYTES_TCP_PUSH_REQUESTS", new TCPLimeSentPushRequestsBytes("LIME_SENT_BYTES_TCP_PUSH_REQUESTS"));
    }

    private static void addSentLimeBytesStatsUDP(String string) {
        StatisticsConstructor.addGroupTreeNode(string, "STATS_SENT_UDP_BYTES");
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_MESSAGES", new UDPLimeSentBytes("LIME_SENT_BYTES_UDP_MESSAGES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PING_REQUESTS", new UDPLimeSentPingsBytes("LIME_SENT_BYTES_UDP_PING_REQUESTS"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PING_REPLIES", new UDPLimeSentPongsBytes("LIME_SENT_BYTES_UDP_PING_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_QUERIES", new UDPLimeSentQueriesBytes("LIME_SENT_BYTES_UDP_QUERIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_QUERY_REPLIES", new UDPLimeSentQueryRepliesBytes("LIME_SENT_BYTES_UDP_QUERY_REPLIES"));
        StatisticsConstructor.addStatisticPane("STATS_SENT_UDP_BYTES", "LIME_SENT_BYTES_UDP_PUSH_REQUESTS", new UDPLimeSentPushRequestsBytes("LIME_SENT_BYTES_UDP_PUSH_REQUESTS"));
    }

    private static void addStatisticPane(String string, PaneItem paneItem) {
        StatisticsPaneImpl statisticsPaneImpl = new StatisticsPaneImpl("STATS_" + string + "_TITLE");
        statisticsPaneImpl.add(paneItem);
        _treeManager.addNode("STATISTICS_ROOT_NODE", statisticsPaneImpl);
        _paneManager.addPane(statisticsPaneImpl);
    }

    private static void addStatisticPane(String string, String string2, PaneItem paneItem) {
        StatisticsPaneImpl statisticsPaneImpl = new StatisticsPaneImpl("STATS_" + string2 + "_TITLE");
        statisticsPaneImpl.add(paneItem);
        _treeManager.addNode(string, statisticsPaneImpl);
        _paneManager.addPane(statisticsPaneImpl);
    }

    private static void addGroupTreeNode(String string, String string2) {
        StatisticsPaneParent statisticsPaneParent = new StatisticsPaneParent(string2);
        _treeManager.addNode(string, statisticsPaneParent);
        _paneManager.addPane(statisticsPaneParent);
    }

    private static void addGroupTreeNode(String string, StatisticsPane statisticsPane) {
        _treeManager.addNode(string, statisticsPane);
        _paneManager.addPane(statisticsPane);
    }

    public void setStatisticsVisible(boolean bl) {
        if (bl) {
            DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
            DIALOG.show();
        } else {
            DIALOG.dispose();
        }
    }

    public boolean isStatisticsVisible() {
        return DIALOG.isVisible();
    }

    public static Component getMainComponent() {
        return DIALOG;
    }

    public static JComponent getComponent() {
        return MAIN_PANEL;
    }

    public static JComponent getStatDisplayComponent() {
        return _paneManager.getFirstDisplayedPaneItem().getStatsComponent();
    }

    static {
        MAIN_PANEL = new PaddedPanel();
        SPLIT_PANE = new JSplitPane(1);
    }

    private class PaneAdapter
    extends ComponentAdapter {
        private PaneAdapter() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            _paneManager.componentResized(componentEvent);
        }
    }
}

