/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.statistics.StatisticsConstructor;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneManager;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeManager;
import com.limegroup.gnutella.statistics.StatisticsManager;
import java.awt.Component;
import java.awt.FileDialog;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public final class StatisticsMediator
implements RefreshListener {
    public static final String ROOT_NODE_KEY = "STATISTICS_ROOT_NODE";
    private static final StatisticsMediator INSTANCE = new StatisticsMediator();
    private static final StatisticsTreeManager TREE_MANAGER = new StatisticsTreeManager();
    private static final StatisticsPaneManager PANE_MANAGER = new StatisticsPaneManager();
    private static final StatisticsConstructor CONSTRUCTOR = new StatisticsConstructor(TREE_MANAGER, PANE_MANAGER);

    public static synchronized StatisticsMediator instance() {
        return INSTANCE;
    }

    private StatisticsMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_STATISTICS_WINDOW"));
    }

    public final void setStatisticsVisible(boolean bl) {
        CONSTRUCTOR.setStatisticsVisible(bl);
    }

    public final boolean isStatisticsVisible() {
        return CONSTRUCTOR.isStatisticsVisible();
    }

    public final void handleSelection(String string) {
        PANE_MANAGER.show(string);
    }

    public JFileChooser getDirectoryChooser() {
        return GUIMediator.getDirectoryChooser();
    }

    public FileDialog getOSXDirectoryChooser() {
        return GUIMediator.getOSXDirectoryChooser();
    }

    public Component getMainStatisticsComponent() {
        return StatisticsConstructor.getMainComponent();
    }

    public JComponent getComponent() {
        return StatisticsConstructor.getComponent();
    }

    public static JComponent getStatDisplayComponent() {
        return StatisticsConstructor.getStatDisplayComponent();
    }

    public void refresh() {
        PANE_MANAGER.refresh();
    }

    public void setAdvancedStatsVisible(boolean bl) {
        StatisticsManager.instance().setRecordAdvancedStats(bl);
        StatisticsConstructor.setAdvancedStatsVisible(bl);
    }
}

