/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class StatisticsPaneManager
implements RefreshListener {
    private final JPanel MAIN_PANEL = new JPanel();
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final Map STATISTICS_PANE_MAP = new HashMap();
    private String _selectedPaneKey;

    public StatisticsPaneManager() {
        this.MAIN_PANEL.setLayout(this.CARD_LAYOUT);
    }

    public void show(String string) {
        this.CARD_LAYOUT.show(this.MAIN_PANEL, string);
        this._selectedPaneKey = string;
    }

    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public PaneItem getFirstDisplayedPaneItem() {
        StatisticsPane statisticsPane = (StatisticsPane)this.STATISTICS_PANE_MAP.get(this._selectedPaneKey);
        return statisticsPane.getFirstPaneItem();
    }

    public void addPane(StatisticsPane statisticsPane) {
        this.MAIN_PANEL.add((Component)statisticsPane.getComponent(), statisticsPane.getName());
        this.STATISTICS_PANE_MAP.put(statisticsPane.getName(), statisticsPane);
    }

    public void refresh() {
        Iterator iterator = this.STATISTICS_PANE_MAP.values().iterator();
        while (iterator.hasNext()) {
            ((StatisticsPane)iterator.next()).refresh();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        Iterator iterator = this.STATISTICS_PANE_MAP.values().iterator();
        while (iterator.hasNext()) {
            ((StatisticsPane)iterator.next()).componentResized(componentEvent, this.MAIN_PANEL);
        }
    }
}

