/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeModel;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeSelectionListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

final class StatisticsTreeManager {
    private JScrollPane _scrollPane;
    private final StatisticsTreeModel TREE_MODEL = new StatisticsTreeModel();
    private final JTree TREE = new JTree();

    StatisticsTreeManager() {
        this.TREE.setEditable(false);
        this.TREE.setShowsRootHandles(true);
        this.TREE.setRootVisible(false);
        this.TREE.putClientProperty("JTree.lineStyle", "Angled");
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.addTreeSelectionListener(new StatisticsTreeSelectionListener(this.TREE));
        this.TREE.setModel(this.TREE_MODEL.getTreeModel());
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setOpaque(false);
        defaultTreeCellRenderer.setBackground(null);
        defaultTreeCellRenderer.setBackgroundNonSelectionColor(null);
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.TREE.setCellRenderer(defaultTreeCellRenderer);
        this._scrollPane = new JScrollPane(this.TREE);
        this._scrollPane.getViewport().setBackground(Color.white);
        this._scrollPane.setPreferredSize(new Dimension(125, 2000));
        this._scrollPane.setMinimumSize(new Dimension(125, 300));
    }

    void advancedSize() {
        this._scrollPane.setPreferredSize(new Dimension(200, 2000));
        this._scrollPane.setMinimumSize(new Dimension(200, 300));
    }

    void defaultSize() {
        this._scrollPane.setPreferredSize(new Dimension(125, 2000));
        this._scrollPane.setMinimumSize(new Dimension(125, 300));
    }

    void addNode(String string, StatisticsPane statisticsPane) {
        this.TREE_MODEL.addNode(string, statisticsPane);
    }

    Component getComponent() {
        return this._scrollPane;
    }

    void removeAllChildren(String string) {
        this.TREE_MODEL.removeAllChildren(string);
    }

    JTree getTree() {
        return this.TREE;
    }
}

