/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.StatisticsPaneParent;
import com.limegroup.gnutella.gui.statistics.StatisticsTreeNode;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

final class StatisticsTreeModel {
    private DefaultTreeModel _treeModel;
    private final StatisticsTreeNode ROOT = new StatisticsTreeNode(new StatisticsPaneParent("STATISTICS_ROOT_NODE"), "");

    StatisticsTreeModel() {
        this._treeModel = new DefaultTreeModel(this.ROOT);
    }

    void addNode(String string, StatisticsPane statisticsPane) {
        MutableTreeNode mutableTreeNode;
        StatisticsTreeNode statisticsTreeNode = new StatisticsTreeNode(statisticsPane);
        try {
            mutableTreeNode = this.getParentNode(this.ROOT, string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        if (mutableTreeNode == null) {
            return;
        }
        this._treeModel.insertNodeInto(statisticsTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        this._treeModel.reload(mutableTreeNode);
    }

    void removeAllChildren(String string) {
        try {
            MutableTreeNode mutableTreeNode = this.getParentNode(this.ROOT, string);
            int n = this._treeModel.getChildCount(mutableTreeNode) - 1;
            while (n >= 0) {
                MutableTreeNode mutableTreeNode2 = (MutableTreeNode)this._treeModel.getChild(mutableTreeNode, n);
                this._treeModel.removeNodeFromParent(mutableTreeNode2);
                --n;
            }
            this._treeModel.reload();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private final MutableTreeNode getParentNode(MutableTreeNode mutableTreeNode, String string) throws IOException {
        if (string == "STATISTICS_ROOT_NODE") {
            return this.ROOT;
        }
        int n = 0;
        int n2 = mutableTreeNode.getChildCount();
        while (n < n2) {
            StatisticsTreeNode statisticsTreeNode = (StatisticsTreeNode)mutableTreeNode.getChildAt(n);
            if (statisticsTreeNode.getTitleKey().equals(string)) {
                return statisticsTreeNode;
            }
            MutableTreeNode mutableTreeNode2 = this.getParentNode(statisticsTreeNode, string);
            if (mutableTreeNode2 != null) {
                return mutableTreeNode2;
            }
            if (statisticsTreeNode.isRoot() && n == n2 - 1) {
                String string2 = "Parent node not in statistics tree.";
                throw new IOException(string2);
            }
            ++n;
        }
        return null;
    }

    final TreeModel getTreeModel() {
        return this._treeModel;
    }
}

