/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.statistics.panes.AverageStatHandler;
import com.limegroup.gnutella.gui.statistics.panes.StatisticDisplayer;
import com.limegroup.gnutella.statistics.Statistic;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.NumberFormat;
import javax.swing.JComponent;

final class AveragesPainter
extends JComponent
implements ComponentListener,
StatisticDisplayer {
    private final List LIST = new LinkedList();
    private static final String NAME = GUIMediator.getStringResource("STATS_LEGEND_NAME");
    private static final String AVERAGE = GUIMediator.getStringResource("STATS_LEGEND_AVERAGE");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final int NAME_COLUMN_WIDTH = 160;
    private static final int AVERAGE_COLUMN_WIDTH = 54;
    private static final int RECT_WIDTH = 214;

    AveragesPainter() {
        this.addComponentListener(this);
    }

    public void registerStatistic(Statistic statistic, String string) {
    }

    public void registerDualStatistic(Statistic statistic, Statistic statistic2, String string) {
        AverageStatHandler averageStatHandler = new AverageStatHandler(statistic, statistic2, string);
        this.LIST.add(averageStatHandler);
    }

    public void refresh() {
        this.repaint();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setWriteStatsToFile(boolean bl) {
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 1);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() + 1;
        int n2 = fontMetrics.getLeading() / 2 + fontMetrics.getMaxAscent();
        int n3 = this.getWidth() / 2 - 107;
        int n4 = n3 + 160;
        int n5 = n4 + 54;
        int n6 = 0;
        graphics.drawString(NAME, n3 + 3, n6 + n2);
        graphics.drawString(AVERAGE, n4 + 3, n6 + n2);
        graphics.drawLine(n3, n6 += n, n3 + 214, n6);
        ++n6;
        Iterator iterator = this.LIST.iterator();
        while (iterator.hasNext()) {
            AverageStatHandler averageStatHandler = (AverageStatHandler)iterator.next();
            double d = averageStatHandler.getByteStat().getTotal();
            double d2 = averageStatHandler.getNumberStat().getTotal();
            double d3 = 0.0;
            if (d2 != 0.0) {
                d3 = d / d2;
            }
            NUMBER_FORMAT.setMaximumFractionDigits(3);
            String string = NUMBER_FORMAT.format(d3);
            String string2 = averageStatHandler.getDisplayName();
            graphics.drawString(string2, n3 + 3, n6 + n2);
            graphics.drawString(string, n4 + 3, n6 + n2);
            n6 += n;
        }
        graphics.drawRect(n3, 0, 214, n6 - 0);
        graphics.drawLine(n4, 0, n4, n6);
        graphics.drawLine(n5, 0, n5, n6);
        graphics.setFont(font);
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }
}

