/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;

public final class GraphAxisData {
    private static final int BYTES_PER_KILOBYTE = 1024;
    private final int X_INCREMENT;
    private final int X_PIXEL_VALUE;
    private final double ULTRAPEER_Y_PIXELS;
    private final double LEAF_Y_PIXELS;
    private final int ULTRAPEER_Y_INCREMENT;
    private final int LEAF_Y_INCREMENT;
    private final int ULTRAPEER_TOTAL_Y_VALUES;
    private final int LEAF_TOTAL_Y_VALUES;
    private final int Y_SCALE;
    private final String X_AXIS_LABEL;
    private final String Y_AXIS_LABEL;
    private static int DEFAULT_X_PIXELS = 2;
    private static int DEFAULT_X_INCREMENT = 20;
    private static final double DEFAULT_ULTRAPEER_Y_PIXELS = 0.35;
    private static final double DEFAULT_LEAF_Y_PIXELS = 3.0;
    private static final double DEFAULT_ULTRAPEER_Y_KILOBYTE_PIXELS = 0.6;
    private static final double DEFAULT_LEAF_Y_KILOBYTE_PIXELS = 3.0;
    private static final int DEFAULT_ULTRAPEER_Y_INCREMENT = 100;
    private static final int DEFAULT_LEAF_Y_INCREMENT = 10;
    private static final int DEFAULT_ULTRAPEER_Y_KILOBYTE_INCREMENT = 60;
    private static final int DEFAULT_LEAF_Y_KILOBYTE_INCREMENT = 10;
    private static final int DEFAULT_ULTRAPEER_TOTAL_Y_VALUES = 500;
    private static final int DEFAULT_LEAF_TOTAL_Y_VALUES = 60;
    private static final int DEFAULT_ULTRAPEER_TOTAL_Y_KILOBYTE_VALUES = 300;
    private static final int DEFAULT_LEAF_TOTAL_Y_KILOBYTE_VALUES = 60;

    GraphAxisData() {
        this(0.35, 3.0, 100, 10, 500, 60);
    }

    GraphAxisData(double d, double d2, int n, int n2, int n3, int n4) {
        this(d, d2, n, n2, n3, n4, 1, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("DEFAULT_Y_AXIS_LABEL"));
    }

    GraphAxisData(double d, double d2, int n, int n2, int n3, int n4, int n5, String string, String string2) {
        this(DEFAULT_X_PIXELS, d, d2, DEFAULT_X_INCREMENT, n, n2, n3, n4, n5, string, string2);
    }

    static GraphAxisData createKilobyteGraphData() {
        return new GraphAxisData(0.6, 3.0, 60, 10, 300, 60, 1024, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("Y_AXIS_BANDWIDTH_LABEL"));
    }

    static GraphAxisData createBandwidthGraphData() {
        return new GraphAxisData(0.6, 0.6, 60, 60, 300, 300, 1024, GUIMediator.getStringResource("DEFAULT_X_AXIS_LABEL"), GUIMediator.getStringResource("Y_AXIS_BANDWIDTH_LABEL"));
    }

    private GraphAxisData(int n, double d, double d2, int n2, int n3, int n4, int n5, int n6, int n7, String string, String string2) {
        this.X_PIXEL_VALUE = n;
        this.ULTRAPEER_Y_PIXELS = d;
        this.LEAF_Y_PIXELS = d2;
        this.ULTRAPEER_Y_INCREMENT = n3;
        this.LEAF_Y_INCREMENT = n4;
        this.X_INCREMENT = n2;
        this.ULTRAPEER_TOTAL_Y_VALUES = n5;
        this.LEAF_TOTAL_Y_VALUES = n6;
        this.Y_SCALE = n7;
        this.X_AXIS_LABEL = string;
        this.Y_AXIS_LABEL = string2;
    }

    public int getXPixelValue() {
        return this.X_PIXEL_VALUE;
    }

    public double getYPixelValue() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_Y_PIXELS;
        }
        return this.LEAF_Y_PIXELS;
    }

    public int getYScale() {
        return this.Y_SCALE;
    }

    public int getXIncrement() {
        return this.X_INCREMENT;
    }

    public int getYIncrement() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_Y_INCREMENT;
        }
        return this.LEAF_Y_INCREMENT;
    }

    public int getTotalXValues() {
        return 200;
    }

    public int getTotalYValues() {
        if (RouterService.isSupernode()) {
            return this.ULTRAPEER_TOTAL_Y_VALUES;
        }
        return this.LEAF_TOTAL_Y_VALUES;
    }

    public String getXAxisLabel() {
        return this.X_AXIS_LABEL;
    }

    public String getYAxisLabel() {
        return this.Y_AXIS_LABEL;
    }
}

