/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.statistics.panes.GraphAxisData;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;

final class GraphBorder
extends AbstractBorder {
    private final int OFFSET = 30;
    private final int NUM_X_TICKS;
    private final int NUM_Y_TICKS;
    private final int X_AXIS_PIXEL_LENGTH;
    private final int Y_AXIS_PIXEL_LENGTH;
    private final GraphAxisData DATA;

    GraphBorder(GraphAxisData graphAxisData) {
        this.DATA = graphAxisData;
        this.NUM_X_TICKS = this.DATA.getTotalXValues() / this.DATA.getXIncrement();
        this.NUM_Y_TICKS = this.DATA.getTotalYValues() / this.DATA.getYIncrement();
        this.X_AXIS_PIXEL_LENGTH = this.DATA.getTotalXValues() * this.DATA.getXPixelValue();
        this.Y_AXIS_PIXEL_LENGTH = (int)((double)this.DATA.getTotalYValues() * this.DATA.getYPixelValue());
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 2;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 + n4 - 30;
        StatisticsMediator.instance();
        JComponent jComponent = StatisticsMediator.getStatDisplayComponent();
        int n9 = jComponent.getWidth() - 30;
        int n10 = jComponent.getHeight() - 30 - 60;
        int n11 = this.DATA.getYIncrement();
        int n12 = 0;
        while (n12 < n5) {
            n6 = n2 + n4 - n12 - 30;
            graphics.drawLine(n + 30, n6, n9, n6);
            n7 = n + n12 + 30;
            int n13 = n8 - n10;
            graphics.drawLine(n7, n13, n7, n8);
            ++n12;
        }
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 1);
        graphics.setFont(font2);
        this.drawHashedLineX(n + 30, n6, n + n3, n6, graphics);
        this.drawHashedLineY(n7, n2, n7, n8, graphics);
        graphics.setFont(font);
    }

    int getOffset() {
        return 30;
    }

    private void drawHashedLineX(int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = n2 - 4;
        int n6 = n2 + 4;
        double d = n;
        int n7 = this.DATA.getXIncrement();
        StatisticsMediator.instance();
        JComponent jComponent = StatisticsMediator.getStatDisplayComponent();
        double d2 = jComponent.getWidth() - 30 - n;
        double d3 = d2 / (double)this.DATA.getTotalXValues();
        int n8 = 0;
        int n9 = this.DATA.getTotalXValues() / n7 + 1;
        while (n8 < n9) {
            graphics.drawLine((int)d, n5, (int)d, n6);
            graphics.drawString(new Integer((this.NUM_X_TICKS - n8) * n7).toString(), (int)d, n5 + 20);
            d += d3 * (double)n7;
            ++n8;
        }
        graphics.drawString(this.DATA.getXAxisLabel(), (int)((double)n + d2 / 2.0), n2 + 30);
    }

    private void drawHashedLineY(int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = n - 4;
        int n6 = n + 4;
        double d = n4;
        int n7 = this.DATA.getYIncrement();
        StatisticsMediator.instance();
        JComponent jComponent = StatisticsMediator.getStatDisplayComponent();
        double d2 = (double)(jComponent.getHeight() - 30 - n2 - 60) / (double)this.DATA.getTotalYValues();
        double d3 = d2 * (double)n7;
        int n8 = 0;
        int n9 = this.DATA.getTotalYValues() / n7 + 1;
        while (n8 < n9) {
            graphics.drawLine(n5, (int)d, n6, (int)d);
            graphics.drawString(new Integer(n8 * n7).toString(), n5 - 20, (int)d);
            ++n8;
            d -= d3;
        }
        graphics.drawString(this.DATA.getYAxisLabel(), 0, (int)(d + d3 - 20.0));
    }
}

