/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.statistics.panes.GraphAxisData;
import com.limegroup.gnutella.gui.statistics.panes.GraphBorder;
import com.limegroup.gnutella.gui.statistics.panes.StatHandler;
import com.limegroup.gnutella.gui.statistics.panes.StatisticDisplayer;
import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.util.IntBuffer;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.NumberFormat;
import javax.swing.JComponent;

final class GraphPainter
extends JComponent
implements ComponentListener,
StatisticDisplayer {
    private final int[] X_COORDS = new int[200];
    private final GraphBorder BORDER;
    private final List LIST = new LinkedList();
    private static int _curColor = 0;
    private final Color[] GRAPH_COLORS = new Color[]{new Color(255, 255, 255), new Color(0, 153, 0), new Color(255, 102, 255), new Color(255, 255, 0), new Color(255, 51, 0), new Color(51, 153, 204), new Color(255, 153, 0), new Color(153, 0, 51), new Color(51, 0, 153)};
    private static int DEFAULT_X_PIXELS = 2;
    private static int DEFAULT_X_INCREMENT = 20;
    private static GraphAxisData DEFAULT_AXIS_DATA = new GraphAxisData();
    private final GraphAxisData AXIS_DATA;
    private static final String NAME = GUIMediator.getStringResource("STATS_LEGEND_NAME");
    private static final String AVERAGE = GUIMediator.getStringResource("STATS_LEGEND_AVERAGE");
    private static final String MAX = GUIMediator.getStringResource("STATS_LEGEND_MAX");
    private static final String TOTAL = GUIMediator.getStringResource("STATS_LEGEND_TOTAL");
    private static final String COLOR = GUIMediator.getStringResource("STATS_LEGEND_COLOR");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private double _yPixelFactor = 0.0;
    private static final int NAME_COLUMN_WIDTH = 160;
    private static final int AVERAGE_COLUMN_WIDTH = 54;
    private static final int MAX_COLUMN_WIDTH = 54;
    private static final int TOTAL_COLUMN_WIDTH = 70;
    private static final int COLOR_COLUMN_WIDTH = 44;
    private static final int RECT_WIDTH = 382;
    private static final int COLOR_BOX_WIDTH = 10;

    GraphPainter() {
        this(DEFAULT_AXIS_DATA);
    }

    GraphPainter(GraphAxisData graphAxisData) {
        this.AXIS_DATA = graphAxisData;
        this.BORDER = new GraphBorder(graphAxisData);
        this.setBorder(this.BORDER);
        this.addComponentListener(this);
    }

    public void registerStatistic(Statistic statistic, String string) {
        StatHandler statHandler = new StatHandler(statistic, this.GRAPH_COLORS[_curColor], string);
        this.LIST.add(statHandler);
        _curColor = _curColor != this.GRAPH_COLORS.length - 1 ? ++_curColor : 0;
    }

    public void registerDualStatistic(Statistic statistic, Statistic statistic2, String string) {
    }

    public void refresh() {
        this.repaint();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setWriteStatsToFile(boolean bl) {
        List list = this.LIST;
        synchronized (list) {
            Iterator iterator = this.LIST.iterator();
            while (iterator.hasNext()) {
                Statistic statistic = ((StatHandler)iterator.next()).getStat();
                statistic.setWriteStatToFile(bl);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() - 1);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight() + 1;
        int n2 = fontMetrics.getLeading() / 2 + fontMetrics.getMaxAscent();
        int n3 = (n - 10) / 2;
        int n4 = this.getWidth() - 382 - 10;
        int n5 = n4 + 160;
        int n6 = n5 + 54;
        int n7 = n6 + 54;
        int n8 = n7 + 70;
        int n9 = n8 + 17;
        int n10 = 0;
        graphics.drawString(NAME, n4 + 3, n10 + n2);
        graphics.drawString(AVERAGE, n5 + 3, n10 + n2);
        graphics.drawString(MAX, n6 + 3, n10 + n2);
        graphics.drawString(TOTAL, n7 + 3, n10 + n2);
        graphics.drawString(COLOR, n8 + 3, n10 + n2);
        graphics.drawLine(n4, n10 += n, n4 + 382, n10);
        ++n10;
        Iterator iterator = this.LIST.iterator();
        while (iterator.hasNext()) {
            StatHandler statHandler = (StatHandler)iterator.next();
            Statistic statistic = statHandler.getStat();
            int[] nArray = statHandler.getData();
            String string = statHandler.getDisplayName();
            NUMBER_FORMAT.setMaximumFractionDigits(3);
            String string2 = NUMBER_FORMAT.format(statistic.getAverage());
            String string3 = NUMBER_FORMAT.format(statistic.getMax());
            NUMBER_FORMAT.setMaximumFractionDigits(1);
            String string4 = NUMBER_FORMAT.format(statistic.getTotal());
            IntBuffer intBuffer = statistic.getStatHistory();
            int n11 = 0;
            while (n11 < intBuffer.size()) {
                int n12 = (int)((double)intBuffer.get(n11) * this._yPixelFactor / (double)this.AXIS_DATA.getYScale());
                nArray[n11] = this.getHeight() - this.BORDER.getOffset() - n12;
                ++n11;
            }
            graphics.setColor(statHandler.getColor());
            graphics.drawPolyline(this.X_COORDS, nArray, nArray.length);
            graphics.fillRect(n9, n10 + n3, 10, 10);
            graphics.setColor(color);
            graphics.drawRect(n9 - 1, n10 + n3 - 1, 11, 11);
            graphics.drawString(string, n4 + 3, n10 + n2);
            graphics.drawString(string2, n5 + 3, n10 + n2);
            graphics.drawString(string3, n6 + 3, n10 + n2);
            graphics.drawString(string4, n7 + 3, n10 + n2);
            n10 += n;
        }
        graphics.drawRect(n4, 0, 382, n10 - 0);
        graphics.drawLine(n5, 0, n5, n10);
        graphics.drawLine(n6, 0, n6, n10);
        graphics.drawLine(n7, 0, n7, n10);
        graphics.drawLine(n8, 0, n8, n10);
        graphics.setFont(font);
    }

    public void componentResized(ComponentEvent componentEvent) {
        double d = (double)(this.getWidth() - this.BORDER.getOffset() - 30) / (double)this.AXIS_DATA.getTotalXValues();
        double d2 = this.BORDER.getOffset();
        int n = 0;
        while (n < this.X_COORDS.length) {
            this.X_COORDS[n] = (int)d2;
            ++n;
            d2 += d;
        }
        this._yPixelFactor = (double)(this.getHeight() - this.BORDER.getOffset() - 60) / (double)this.AXIS_DATA.getTotalYValues();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }
}

