/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.tables.ChatRenderer;
import com.limegroup.gnutella.gui.tables.ColorRenderer;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.RemoveListener;
import com.limegroup.gnutella.gui.tables.SelectionListener;
import com.limegroup.gnutella.gui.tables.SortHeaderRenderer;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.sun.java.util.collections.Arrays;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class AbstractTableMediator
implements ComponentMediator,
HeaderMouseObserver,
ThemeObserver {
    protected static final SettingsManager SETTINGS = SettingsManager.instance();
    protected JPanel MAIN_PANEL;
    protected DataLineModel DATA_MODEL;
    protected LimeJTable TABLE;
    protected JPopupMenu POPUP_MENU;
    protected ButtonRow BUTTON_ROW;
    public ActionListener REMOVE_LISTENER;
    public MouseListener DEFAULT_LISTENER;
    public MouseInputListener HEADER_LISTENER;
    public ListSelectionListener SELECTION_LISTENER;
    protected static final TableCellRenderer PROGRESS_BAR_RENDERER = new ProgressBarRenderer();
    protected static final TableCellRenderer CHAT_RENDERER = new ChatRenderer();
    protected static final TableCellRenderer COLOR_RENDERER = new ColorRenderer();
    public static final TableCellRenderer HEADER_RENDERER = new SortHeaderRenderer();
    protected static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    protected boolean _sortInRealTime = true;
    protected Resorter RESORTER = new Resorter();
    protected Component TABLE_PANE;
    protected JScrollPane SCROLL_PANE;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ColoredCell;

    protected AbstractTableMediator() {
        this.updateSplashScreen();
        this.buildListeners();
        this.setupConstants();
        Assert.that(this.DATA_MODEL != null, "DATA_MODEL not set.");
        Assert.that(this.TABLE != null, "TABLE not set.");
        this.setupTable();
        this.addListeners();
        this.setPreferredWidths();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setupMainPanel();
        this.handleNoSelection();
        GUIMediator.addThemeObserver(this);
    }

    protected abstract void updateSplashScreen();

    protected abstract void setupConstants();

    protected void buildListeners() {
        this.DEFAULT_LISTENER = new DefaultMouseListener(this);
        this.SELECTION_LISTENER = new SelectionListener(this);
        this.HEADER_LISTENER = new HeaderMouseListener(this);
        this.REMOVE_LISTENER = new RemoveListener(this);
    }

    protected void addListeners() {
        this.TABLE.addMouseListener(this.DEFAULT_LISTENER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.SELECTION_LISTENER);
        this.TABLE.getTableHeader().addMouseListener(this.HEADER_LISTENER);
        this.TABLE.getTableHeader().addMouseMotionListener(this.HEADER_LISTENER);
    }

    protected void setupTable() {
        this.TABLE.setRowHeight(this.TABLE.getRowHeight() + 1);
        this.TABLE.setShowGrid(false);
        this.TABLE.setColumnSelectionAllowed(false);
    }

    protected abstract void setPreferredWidths();

    protected void setDefaultRenderers() {
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder, PROGRESS_BAR_RENDERER);
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder, CHAT_RENDERER);
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell, COLOR_RENDERER);
        Enumeration<TableColumn> enumeration = this.TABLE.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(HEADER_RENDERER);
        }
    }

    protected void setDefaultEditors() {
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            if (this.BUTTON_ROW != null) {
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        }
    }

    protected Component getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        jPanel.setBackground(color);
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        this.SCROLL_PANE.getViewport().setBackground(color);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.TABLE.getTableHeader().getBackground());
        jPanel2.setBorder(BorderFactory.createBevelBorder(0));
        this.SCROLL_PANE.setCorner("UPPER_RIGHT_CORNER", jPanel2);
        jPanel.add(this.SCROLL_PANE);
        this.TABLE_PANE = jPanel;
        return jPanel;
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        if (this.TABLE_PANE == null) {
            return;
        }
        this.TABLE_PANE.setBackground(color);
        this.SCROLL_PANE.getViewport().setBackground(color);
    }

    public void add(Object object) {
        int n;
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        if ((n = this._sortInRealTime && this.DATA_MODEL.isSorted() ? this.DATA_MODEL.addSorted(object) : this.DATA_MODEL.add(object)) == 0) {
            this.TABLE.removeRowSelectionInterval(0, 0);
        }
    }

    public void addUnsorted(Object object) {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        if (this.DATA_MODEL.add(object) == 0) {
            this.TABLE.removeRowSelectionInterval(0, 0);
        }
    }

    public void remove(Object object) {
        int n = this.DATA_MODEL.getRow(object);
        if (n != -1) {
            this.removeRow(n);
        }
    }

    public void removeRow(int n) {
        this.DATA_MODEL.remove(n);
    }

    public void refresh() {
        if (this.TABLE.isShowing()) {
            this.doRefresh();
            this.resort();
        }
    }

    protected void doRefresh() {
        this.DATA_MODEL.refresh();
    }

    public void update(Object object) {
        this.DATA_MODEL.update(object);
        this.resort();
    }

    public void resort() {
        this.RESORTER.doResort(false);
    }

    public void forceResort() {
        this.RESORTER.doResort(true);
    }

    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        Arrays.sort(nArray);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = nArray[n];
            this.DATA_MODEL.remove(n2);
            --n;
        }
        this.clearSelection();
    }

    protected JPopupMenu createColumnSelectionMenu() {
        return new ColumnSelectionMenu(this.TABLE, this.DATA_MODEL).getComponent();
    }

    public void handleRightMouseClick(Point point) {
        int n = this.TABLE.rowAtPoint(point);
        if (n < 0) {
            return;
        }
        if (!this.TABLE.getSelectionModel().isSelectedIndex(n)) {
            this.TABLE.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    public void handlePopupMenu(Point point) {
        this.handleRightMouseClick(point);
        if (this.POPUP_MENU != null) {
            this.POPUP_MENU.show(this.TABLE, point.x, point.y);
        }
    }

    public void handleHeaderColumnLeftClick(Point point) {
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        int n2 = this.TABLE.convertColumnIndexToModel(n);
        if (n2 != -1) {
            this.TABLE.sortColumn(n2, !this.DATA_MODEL.isSortAscending());
            this.sortAndMaintainSelection(n2);
        }
    }

    public void handleHeaderPopupMenu(Point point) {
        this.createColumnSelectionMenu().show(this.TABLE.getTableHeader(), point.x, point.y);
    }

    public void handleHeaderColumnPressed(Point point) {
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        int n2 = this.TABLE.convertColumnIndexToModel(n);
        if (n2 != -1) {
            this.TABLE.setPressedColumnIndex(n2);
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    public void handleHeaderColumnReleased(Point point) {
        this.TABLE.setPressedColumnIndex(-1);
        JTableHeader jTableHeader = this.TABLE.getTableHeader();
        int n = jTableHeader.columnAtPoint(point);
        if (n != -1) {
            jTableHeader.repaint(jTableHeader.getHeaderRect(n));
        }
    }

    public void setButtonEnabled(int n, boolean bl) {
        if (this.BUTTON_ROW != null) {
            this.BUTTON_ROW.setButtonEnabled(n, bl);
        }
    }

    public void setPopupItemEnabled(int n, boolean bl) {
        if (this.POPUP_MENU != null) {
            this.POPUP_MENU.getComponent(n).setEnabled(bl);
        }
    }

    public void clearTable() {
        this.DATA_MODEL.clear();
        this.handleNoSelection();
    }

    protected void clearSelection() {
        this.TABLE.clearSelection();
        this.handleNoSelection();
    }

    protected void sortAndMaintainSelection(int n) {
        int[] nArray = this.TABLE.getSelectedRows();
        DataLine[] dataLineArray = new DataLine[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            dataLineArray[n2] = this.DATA_MODEL.get(nArray[n2]);
            ++n2;
        }
        if (n == -1) {
            this.DATA_MODEL.resort();
        } else {
            this.DATA_MODEL.sort(n);
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = this.DATA_MODEL.getRow(dataLineArray[n3]);
            this.TABLE.addRowSelectionInterval(n4, n4);
            ++n3;
        }
    }

    public abstract void handleNoSelection();

    public abstract void handleSelection(int var1);

    public abstract void handleMouseDoubleClick(Point var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected final class Resorter
    implements Runnable {
        private boolean active = false;
        private boolean force = false;

        protected Resorter() {
        }

        public void doResort(boolean bl) {
            if (!this.active && AbstractTableMediator.this._sortInRealTime && AbstractTableMediator.this.TABLE.isShowing()) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
            this.force |= bl;
        }

        public void run() {
            try {
                if (!AbstractTableMediator.this.TABLE.isEditing() && (this.force || AbstractTableMediator.this.DATA_MODEL.needsResort())) {
                    AbstractTableMediator.this.sortAndMaintainSelection(-1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.active = false;
            this.force = false;
        }
    }
}

