/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.List;
import javax.swing.table.AbstractTableModel;

public class BasicDataLineModel
extends AbstractTableModel
implements DataLineModel {
    private List _list = new ArrayList();
    private int _ascending = 1;
    private int _activeColumn;
    private final Class _dataLineClass;
    private final DataLine _internalDataLine;
    protected boolean _isSorted = false;

    public BasicDataLineModel(Class clazz) {
        this._dataLineClass = clazz;
        Object var2_2 = null;
        try {
            var2_2 = this._dataLineClass.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.that(false, illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            Assert.that(false, instantiationException.getMessage());
        }
        catch (ClassCastException classCastException) {
            Assert.that(false, classCastException.getMessage());
        }
        this._internalDataLine = var2_2 != null ? (DataLine)var2_2 : null;
    }

    public String[] getToolTipArray(int n) {
        return ((DataLine)this._list.get(n)).getToolTipArray();
    }

    public boolean isSortAscending() {
        return this._ascending == 1;
    }

    public void sort(int n) {
        this._ascending = -this._ascending;
        this._activeColumn = n;
        Collections.sort(this._list, this);
        this.fireTableDataChanged();
        this._isSorted = true;
    }

    public boolean isSorted() {
        return this._isSorted;
    }

    public void resort() {
        if (this._isSorted) {
            this._ascending = -this._ascending;
            this.sort(this._activeColumn);
        }
    }

    public boolean needsResort() {
        return this._isSorted && this._internalDataLine.isDynamic(this._activeColumn);
    }

    public void clear() {
        this._list.clear();
        this.fireTableDataChanged();
    }

    public Object refresh() {
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            ((DataLine)this._list.get(n2)).update();
            ++n2;
        }
        this.fireTableRowsUpdated(0, n);
        return null;
    }

    public int update(Object object) {
        int n = this.getRow(object);
        ((DataLine)this._list.get(n)).update();
        this.fireTableRowsUpdated(n, n);
        return n;
    }

    public DataLine createDataLine(Object object) {
        try {
            DataLine dataLine = (DataLine)this._dataLineClass.newInstance();
            dataLine.initialize(object);
            return dataLine;
        }
        catch (IllegalAccessException illegalAccessException) {
            Assert.that(false, illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            Assert.that(false, instantiationException.getMessage());
        }
        catch (ClassCastException classCastException) {
            Assert.that(false, classCastException.getMessage());
        }
        return null;
    }

    public int getSortedPosition(DataLine dataLine) {
        int n = Collections.binarySearch(this._list, dataLine, this);
        if (n < 0) {
            n = -(n + 1);
        }
        return n;
    }

    public int add(Object object) {
        return this.add(object, 0);
    }

    public int add(Object object, int n) {
        DataLine dataLine = this.createDataLine(object);
        return dataLine == null ? -1 : this.add(dataLine, n);
    }

    public int add(DataLine dataLine) {
        return this.add(dataLine, 0);
    }

    public int add(DataLine dataLine, int n) {
        this._list.add(n, dataLine);
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public int addSorted(Object object) {
        DataLine dataLine = this.createDataLine(object);
        return dataLine == null ? -1 : this.add(dataLine, this.getSortedPosition(dataLine));
    }

    public int addSorted(DataLine dataLine) {
        return this.add(dataLine, this.getSortedPosition(dataLine));
    }

    public DataLine get(int n) {
        return (DataLine)this._list.get(n);
    }

    public DataLine get(Object object) {
        int n = this.getRow(object);
        if (n != -1) {
            return (DataLine)this._list.get(n);
        }
        return null;
    }

    public DataLine get(Object object, int n) {
        int n2 = this.getRow(object, n);
        if (n2 != -1) {
            return (DataLine)this._list.get(n2);
        }
        return null;
    }

    public void remove(int n) {
        ((DataLine)this._list.get(n)).cleanup();
        this._list.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void remove(DataLine dataLine) {
        int n = this._list.indexOf(dataLine);
        if (n != -1) {
            this.remove(n);
        }
    }

    public void remove(Object object) {
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DataLine)this._list.get(n2)).getInitializeObject().equals(object)) {
                this.remove(n2);
                break;
            }
            ++n2;
        }
    }

    public Object getValueAt(int n, int n2) {
        return ((DataLine)this._list.get(n)).getValueAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        ((DataLine)this._list.get(n)).setValueAt(object, n2);
        this.fireTableRowsUpdated(n, n);
    }

    public boolean contains(Object object, int n) {
        int n2 = this._list.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((DataLine)this._list.get(n3)).getValueAt(n).equals(object)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean contains(Object object) {
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DataLine)this._list.get(n2)).getInitializeObject().equals(object)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int getRow(DataLine dataLine) {
        return this._list.indexOf(dataLine);
    }

    public int getRow(Object object, int n) {
        int n2 = this._list.size();
        int n3 = 0;
        while (n3 < n2) {
            if (((DataLine)this._list.get(n3)).getValueAt(n).equals(object)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public int getRow(Object object) {
        int n = this._list.size();
        int n2 = 0;
        while (n2 < n) {
            if (((DataLine)this._list.get(n2)).getInitializeObject().equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int compare(Object object, Object object2) {
        Object object3 = ((DataLine)object).getValueAt(this._activeColumn);
        Object object4 = ((DataLine)object2).getValueAt(this._activeColumn);
        return CommonUtils.compare(object3, object4) * this._ascending;
    }

    public int getRowCount() {
        return this._list.size();
    }

    public int getColumnCount() {
        if (this._internalDataLine == null) {
            return 0;
        }
        return this._internalDataLine.getColumnCount();
    }

    public String getColumnName(int n) {
        if (this._internalDataLine == null) {
            return null;
        }
        return this._internalDataLine.getColumnName(n);
    }

    public Object getColumnId(int n) {
        return this.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        if (this._internalDataLine == null) {
            return null;
        }
        return this._internalDataLine.getColumnClass(n);
    }
}

