/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public final class ChatRenderer
extends JLabel
implements TableCellRenderer,
ThemeObserver {
    private static Border _noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static Color _unselectedForeground;
    private static Color _unselectedBackground;
    private static Icon _chatIcon;

    public ChatRenderer() {
        this.setOpaque(true);
        this.setBorder(_noFocusBorder);
        this.setHorizontalAlignment(0);
    }

    public void updateTheme() {
        _chatIcon = GUIMediator.getThemeImage("chat.gif");
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        _unselectedForeground = color;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        _unselectedBackground = color;
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        if (((Boolean)object).booleanValue()) {
            this.setIcon(_chatIcon);
        } else {
            this.setIcon(null);
        }
        if (bl) {
            super.setForeground(jTable.getSelectionForeground());
            super.setBackground(jTable.getSelectionBackground());
        } else {
            super.setForeground(_unselectedForeground != null ? _unselectedForeground : jTable.getForeground());
            super.setBackground(_unselectedBackground != null ? _unselectedBackground : jTable.getBackground());
        }
        if (bl2) {
            super.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (jTable.isCellEditable(n, n2)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            super.setBorder(_noFocusBorder);
        }
        boolean bl3 = (color = this.getBackground()) != null && color.equals(jTable.getBackground()) && jTable.isOpaque();
        super.setOpaque(!bl3);
        return this;
    }

    static {
        _chatIcon = GUIMediator.getThemeImage("chat.gif");
    }
}

