/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends JComponent
implements TableCellRenderer,
ThemeObserver {
    private Map otherRenderers = new HashMap();

    public ColorRenderer() {
        GUIMediator.addThemeObserver(this);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        ColoredCell coloredCell = (ColoredCell)object;
        Color color = coloredCell.getColor();
        Object object2 = coloredCell.getValue();
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(object2.getClass());
        tableCellRenderer = this.getCachedOrNewRenderer(tableCellRenderer);
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        if (!bl && !bl2) {
            component.setForeground(color);
        }
        return component;
    }

    public void updateTheme() {
        Iterator iterator = this.otherRenderers.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof ThemeObserver)) continue;
            ((ThemeObserver)object).updateTheme();
        }
    }

    public void updateUI() {
        Iterator iterator = this.otherRenderers.values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof JComponent)) continue;
            ((JComponent)object).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = (TableCellRenderer)this.otherRenderers.get(tableCellRenderer);
        if (tableCellRenderer2 == null) {
            Class<?> clazz = tableCellRenderer.getClass();
            try {
                tableCellRenderer2 = (TableCellRenderer)clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                Assert.that(false, illegalAccessException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                Assert.that(false, instantiationException.getMessage());
            }
            catch (ClassCastException classCastException) {
                Assert.that(false, classCastException.getMessage());
            }
            this.otherRenderers.put(tableCellRenderer, tableCellRenderer2);
        }
        return tableCellRenderer2;
    }
}

