/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;

public class ColumnSelectionMenu {
    protected static final String COLUMN_ID = "columnId";
    protected final JPopupMenu _menu = new JPopupMenu();
    private final LimeJTable _table;

    public ColumnSelectionMenu(LimeJTable limeJTable, DataLineModel dataLineModel) {
        this._table = limeJTable;
        SelectionActionListener selectionActionListener = new SelectionActionListener();
        int n = 0;
        while (n < dataLineModel.getColumnCount()) {
            String string = dataLineModel.getColumnName(n);
            Object object = dataLineModel.getColumnId(n);
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, limeJTable.isColumnVisible(string));
            jCheckBoxMenuItem.putClientProperty(COLUMN_ID, object);
            jCheckBoxMenuItem.addActionListener(selectionActionListener);
            this._menu.add(jCheckBoxMenuItem);
            ++n;
        }
    }

    public JPopupMenu getComponent() {
        return this._menu;
    }

    protected class SelectionActionListener
    implements ActionListener {
        protected SelectionActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            try {
                ColumnSelectionMenu.this._table.setColumnVisible(jCheckBoxMenuItem.getClientProperty(ColumnSelectionMenu.COLUMN_ID), jCheckBoxMenuItem.getState());
            }
            catch (LastColumnException lastColumnException) {
                GUIMediator.showError("ERROR_REMOVE_LAST_COL");
            }
        }
    }
}

