/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ComponentMediator;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

final class DefaultMouseListener
implements MouseListener {
    private ComponentMediator cm;

    DefaultMouseListener(ComponentMediator componentMediator) {
        this.cm = componentMediator;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.tryPopup(mouseEvent)) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.cm.handleRightMouseClick(mouseEvent.getPoint());
        } else if (mouseEvent.getClickCount() >= 2) {
            this.cm.handleMouseDoubleClick(mouseEvent.getPoint());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.tryPopup(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public boolean tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.cm.handlePopupMenu(mouseEvent.getPoint());
            return true;
        }
        return false;
    }
}

