/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;

public final class HeaderMouseListener
implements MouseInputListener {
    private HeaderMouseObserver hmo;
    private boolean isResizing = false;

    public HeaderMouseListener(HeaderMouseObserver headerMouseObserver) {
        this.hmo = headerMouseObserver;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.tryPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (!this.isResizing) {
                this.hmo.handleHeaderColumnLeftClick(mouseEvent.getPoint());
            } else {
                this.isResizing = false;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.tryPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (((JTableHeader)mouseEvent.getSource()).getResizingColumn() == null) {
                this.hmo.handleHeaderColumnPressed(mouseEvent.getPoint());
            } else {
                this.isResizing = true;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.tryPopup(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.hmo.handleHeaderColumnReleased(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.isResizing = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    private boolean tryPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.hmo.handleHeaderPopupMenu(mouseEvent.getPoint());
            return true;
        }
        return false;
    }
}

