/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.JMultilineToolTip;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.JSortTable;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class LimeJTable
extends JTable
implements JSortTable {
    protected Map _hiddenColumns = new HashMap();
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;
    protected int pressedColumnIndex = -1;
    private String[] tips;
    private static String[] ZERO_ARRAY_STRING = new String[0];

    public LimeJTable() {
        this.setToolTipText("");
    }

    public LimeJTable(DataLineModel dataLineModel) {
        super(dataLineModel);
        this.setToolTipText("");
    }

    public LimeJTable(DataLineModel dataLineModel, TableColumnModel tableColumnModel) {
        super(dataLineModel, tableColumnModel);
        this.setToolTipText("");
    }

    public LimeJTable(DataLineModel dataLineModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(dataLineModel, tableColumnModel, listSelectionModel);
        this.setToolTipText("");
    }

    public void setPressedColumnIndex(int n) {
        this.pressedColumnIndex = n;
    }

    public int getPressedColumnIndex() {
        return this.convertColumnIndexToView(this.pressedColumnIndex);
    }

    public int getSortedColumnIndex() {
        return this.convertColumnIndexToView(this.sortedColumnIndex);
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void sortColumn(int n, boolean bl) {
        this.sortedColumnIndex = n;
        this.sortedColumnAscending = bl;
    }

    public void setColumnVisible(Object object, boolean bl) throws LastColumnException {
        if (!bl) {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (tableColumnModel.getColumnCount() == 1) {
                throw new LastColumnException();
            }
            TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModel.getColumnIndex(object));
            this._hiddenColumns.put(object, tableColumn);
            this.removeColumn(tableColumn);
        } else {
            TableColumn tableColumn = (TableColumn)this._hiddenColumns.get(object);
            this._hiddenColumns.remove(object);
            this.addColumn(tableColumn);
        }
    }

    public boolean isColumnVisible(Object object) {
        return !this._hiddenColumns.containsKey(object);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.rowAtPoint(point);
        if (n > -1) {
            DataLineModel dataLineModel = (DataLineModel)this.dataModel;
            this.tips = dataLineModel.getToolTipArray(n);
            if (this.tips == null) {
                return null;
            }
            return dataLineModel.get(n).toString();
        }
        this.tips = ZERO_ARRAY_STRING;
        return null;
    }

    public JToolTip createToolTip() {
        JMultilineToolTip jMultilineToolTip = JMultilineToolTip.instance();
        jMultilineToolTip.setToolTipArray(this.tips);
        this.tips = ZERO_ARRAY_STRING;
        return jMultilineToolTip;
    }
}

