/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tabs;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.tabs.Tab;
import javax.swing.Icon;
import javax.swing.JComponent;

abstract class AbstractTab
implements Tab,
ThemeObserver {
    private final String TITLE;
    private final String TOOL_TIP;
    private Icon _icon;
    private final String KEY;
    protected final int INDEX;
    protected final SettingsManager SETTINGS = SettingsManager.instance();

    AbstractTab(String string, int n) {
        this.KEY = string;
        this.INDEX = n;
        this.TITLE = GUIMediator.getStringResource(string + "_TITLE");
        this.TOOL_TIP = GUIMediator.getStringResource(string + "_TIP");
        this._icon = GUIMediator.getThemeImage(string.toLowerCase() + ".gif");
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this._icon = GUIMediator.getThemeImage(this.KEY.toLowerCase() + ".gif");
        GUIMediator.instance().updateTabIcon(this.INDEX);
    }

    public abstract void storeState(boolean var1);

    public abstract JComponent getComponent();

    public String getTitle() {
        return this.TITLE;
    }

    public String getToolTip() {
        return this.TOOL_TIP;
    }

    public Icon getIcon() {
        return this._icon;
    }

    public int getIndex() {
        return this.INDEX;
    }

    public String toString() {
        return this.KEY.toLowerCase() + " tab";
    }
}

