/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.TimeRemainingHolder;

public final class UploadDataLine
extends AbstractDataLine {
    private Uploader UPLOADER;
    private static final String CONNECTING_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_CONNECTING");
    private static final String UPLOADING_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_UPLOADING");
    private static final String LIMIT_REACHED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_LIMITREACHED");
    private static final String FREELOADER_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FREELOADER");
    private static final String PUSH_FAILED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_PUSHFAILED");
    private static final String INTERRUPTED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_INTERRUPTED");
    private static final String COMPLETE_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_COMPLETE");
    private static final String FILE_NOT_FOUND_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_FNF");
    private static final String QUEUED_STATE = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_QUEUED");
    private static final String AVERAGE_BANDWIDTH = GUIMediator.getStringResource("GENERAL_AVERAGE_BANDWIDTH");
    private static final String STARTED_ON = GUIMediator.getStringResource("GENERAL_STARTED_ON");
    private static final String FINISHED_ON = GUIMediator.getStringResource("GENERAL_FINISHED_ON");
    private static final String TIME_SPENT = GUIMediator.getStringResource("GENERAL_TIME_SPENT");
    private String _fileName;
    private String _status;
    private String _hostName;
    private String _userAgent;
    private int _cumulativeAmountRead = 0;
    private int _progress;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private int _size;
    private double _speed;
    private int _timeLeft;
    private boolean _persistConnection;
    private long _startTime;
    private long _endTime;
    private int _state;
    static final int FILE_INDEX = 0;
    static final String FILE_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_NAME");
    static final int HOST_INDEX = 1;
    static final String HOST_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_HOST");
    static final int SIZE_INDEX = 2;
    static final String SIZE_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_SIZE");
    static final int STATUS_INDEX = 3;
    static final String STATUS_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_STATUS");
    static final int CHAT_INDEX = 4;
    static final String CHAT_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_CHAT");
    static final int PROGRESS_INDEX = 5;
    static final String PROGRESS_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_PROGRESS");
    static final int SPEED_INDEX = 6;
    static final String SPEED_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_SPEED");
    static final int TIME_INDEX = 7;
    static final String TIME_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_TIME_REMAINING");
    static final int USER_AGENT_INDEX = 8;
    static final String USER_AGENT_NAME = GUIMediator.getStringResource("UPLOAD_TABLE_STRING_USER_AGENT");
    static final int NUMBER_OF_COLUMNS = 9;
    private boolean _headerParsed;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$SizeHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;

    public int getColumnCount() {
        return 9;
    }

    public void initialize(Object object) {
        super.initialize(object);
        if (this.UPLOADER != null) {
            this._cumulativeAmountRead += this.UPLOADER.amountUploaded();
            this.UPLOADER = (Uploader)object;
        } else {
            this.UPLOADER = (Uploader)object;
            this._fileName = this.UPLOADER.getFileName();
            this._hostName = this.UPLOADER.getHost();
            this._userAgent = this.UPLOADER.getUserAgent();
            this._chatEnabled = this.UPLOADER.isChatEnabled();
            this._browseEnabled = this.UPLOADER.isBrowseHostEnabled();
            this._startTime = System.currentTimeMillis();
            this._size = this.UPLOADER.getFileSize();
        }
        this._endTime = -1L;
        this._status = "";
        this._persistConnection = false;
        this.update();
    }

    public void cleanup() {
        if (!this._persistConnection) {
            this.UPLOADER.stop();
        }
    }

    public Object getValueAt(int n) {
        switch (n) {
            case 0: {
                return this._fileName;
            }
            case 1: {
                return this._hostName;
            }
            case 2: {
                return new SizeHolder(this._size);
            }
            case 3: {
                return this._status;
            }
            case 4: {
                return this._chatEnabled ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Integer(this._progress);
            }
            case 6: {
                return this._speed == -1.0 ? "" : GUIUtils.rate2speed(this._speed);
            }
            case 7: {
                return new TimeRemainingHolder(this._timeLeft);
            }
            case 8: {
                return this._userAgent;
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return FILE_NAME;
            }
            case 1: {
                return HOST_NAME;
            }
            case 2: {
                return SIZE_NAME;
            }
            case 3: {
                return STATUS_NAME;
            }
            case 4: {
                return CHAT_NAME;
            }
            case 5: {
                return PROGRESS_NAME;
            }
            case 6: {
                return SPEED_NAME;
            }
            case 7: {
                return TIME_NAME;
            }
            case 8: {
                return USER_AGENT_NAME;
            }
        }
        return null;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: {
                return class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 2: {
                return class$com$limegroup$gnutella$gui$tables$SizeHolder == null ? (class$com$limegroup$gnutella$gui$tables$SizeHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.SizeHolder")) : class$com$limegroup$gnutella$gui$tables$SizeHolder;
            }
            case 3: {
                return class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 4: {
                return class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder;
            }
            case 5: {
                return class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
            }
            case 6: {
                return class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
            case 7: {
                return class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder == null ? (class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder = UploadDataLine.class$("com.limegroup.gnutella.gui.tables.TimeRemainingHolder")) : class$com$limegroup$gnutella$gui$tables$TimeRemainingHolder;
            }
            case 8: {
                return class$java$lang$String == null ? (class$java$lang$String = UploadDataLine.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        return null;
    }

    public String[] getToolTipArray() {
        String[] stringArray = new String[this._endTime != -1L ? 5 : 4];
        String string = AVERAGE_BANDWIDTH + ": " + GUIUtils.rate2speed(this.UPLOADER.getAverageBandwidth());
        stringArray[0] = STARTED_ON + GUIUtils.msec2DateTime(this._startTime);
        if (this._endTime != -1L) {
            stringArray[1] = FINISHED_ON + GUIUtils.msec2DateTime(this._endTime);
            stringArray[2] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((this._endTime - this._startTime) / 1000L));
            stringArray[3] = "";
            stringArray[4] = string;
        } else {
            stringArray[1] = TIME_SPENT + ": " + GUIUtils.seconds2time((int)((System.currentTimeMillis() - this._startTime) / 1000L));
            stringArray[2] = "";
            stringArray[3] = string;
        }
        return stringArray;
    }

    public boolean isDynamic(int n) {
        switch (n) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    int getLength() {
        return this._size;
    }

    boolean containsUploader(Uploader uploader) {
        return this.UPLOADER.equals(uploader);
    }

    Uploader getUploader() {
        return this.UPLOADER;
    }

    String getHost() {
        return this.UPLOADER.getHost();
    }

    int getFileIndex() {
        return this.UPLOADER.getIndex();
    }

    int getState() {
        this._state = this.UPLOADER.getState();
        return this._state;
    }

    boolean isCompleted() {
        return this._state == 4;
    }

    boolean isChatEnabled() {
        return this._chatEnabled;
    }

    boolean isBrowseEnabled() {
        return this._browseEnabled;
    }

    public void update() {
        this._speed = -1.0;
        this._timeLeft = 0;
        this.updateStatus();
    }

    private void updateStatus() {
        this._state = this.UPLOADER.getState();
        switch (this._state) {
            case 0: {
                this._status = CONNECTING_STATE;
                break;
            }
            case 1: {
                this._status = FREELOADER_STATE;
                break;
            }
            case 4: {
                if (this._status != COMPLETE_STATE) {
                    this.setProgress();
                    if (this._progress == 99) {
                        this._progress = 100;
                    }
                }
                this._status = COMPLETE_STATE;
                break;
            }
            case 2: {
                this._status = LIMIT_REACHED_STATE;
                break;
            }
            case 5: {
                if (this._status != INTERRUPTED_STATE) {
                    this.setProgress();
                }
                this._status = INTERRUPTED_STATE;
                break;
            }
            case 6: {
                this._status = PUSH_FAILED_STATE;
                break;
            }
            case 7: {
                this._status = FILE_NOT_FOUND_STATE;
                break;
            }
            case 3: {
                this._status = UPLOADING_STATE;
                this.setProgress();
                try {
                    this._speed = this.UPLOADER.getMeasuredBandwidth();
                }
                catch (InsufficientDataException insufficientDataException) {
                    this._speed = 0.0;
                }
                if (!(this._speed > 0.0)) break;
                double d = (double)this._size / 1024.0 - ((double)this._cumulativeAmountRead + (double)this.UPLOADER.amountUploaded()) / 1024.0;
                this._timeLeft = (int)(d / this._speed);
                break;
            }
            case 8: {
                Assert.that(false, "Browse Host status in GUI Upload view");
                break;
            }
            case 9: {
                this._status = QUEUED_STATE;
                break;
            }
            default: {
                Assert.that(false, "Unknown status " + this.UPLOADER.getState() + " of uploader");
            }
        }
    }

    private void setProgress() {
        double d = (double)(this._cumulativeAmountRead + this.UPLOADER.amountUploaded()) / (double)this._size;
        this._progress = (int)Math.round(d * 100.0);
    }

    boolean isInactive() {
        return this._state == 4 || this._state == 6 || this._state == 2 || this._state == 5 || this._state == 7 || this._state == 1;
    }

    boolean isUploading() {
        return this._state == 3;
    }

    void setPersistConnection(boolean bl) {
        this._persistConnection = bl;
    }

    void setEndTime(long l) {
        this._endTime = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

