/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.upload;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.upload.BrowseListener;
import com.limegroup.gnutella.gui.upload.ChatListener;
import com.limegroup.gnutella.gui.upload.ClearListener;
import com.limegroup.gnutella.gui.upload.UploadButtons;
import com.limegroup.gnutella.gui.upload.UploadDataLine;
import com.limegroup.gnutella.gui.upload.UploadModel;
import com.limegroup.gnutella.gui.upload.UploadPopupMenu;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import java.awt.Point;
import java.awt.event.ActionListener;
import javax.swing.table.TableColumnModel;

public final class UploadMediator
extends AbstractTableMediator {
    private static int _totalUploads = 0;
    ActionListener CHAT_LISTENER;
    ActionListener CLEAR_LISTENER;
    ActionListener BROWSE_LISTENER;
    private static UploadMediator _instance = new UploadMediator();

    public static UploadMediator instance() {
        return _instance;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.CHAT_LISTENER = new ChatListener(this);
        this.CLEAR_LISTENER = new ClearListener(this);
        this.BROWSE_LISTENER = new BrowseListener(this);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("UPLOAD_TITLE"));
        this.DATA_MODEL = new UploadModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.POPUP_MENU = new UploadPopupMenu(this).getComponent();
        this.BUTTON_ROW = new UploadButtons(this).getComponent();
    }

    protected void setPreferredWidths() {
        TableColumnModel tableColumnModel = this.TABLE.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(160);
        tableColumnModel.getColumn(1).setPreferredWidth(70);
        tableColumnModel.getColumn(2).setPreferredWidth(25);
        tableColumnModel.getColumn(3).setPreferredWidth(100);
        tableColumnModel.getColumn(4).setPreferredWidth(10);
        tableColumnModel.getColumn(5).setPreferredWidth(25);
        tableColumnModel.getColumn(6).setPreferredWidth(15);
        tableColumnModel.getColumn(7).setPreferredWidth(15);
        tableColumnModel.getColumn(8).setPreferredWidth(70);
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_UPLOAD_WINDOW"));
    }

    public UploadMediator() {
        GUIMediator.addRefreshListener(this);
    }

    public void doRefresh() {
        boolean bl = (Boolean)this.DATA_MODEL.refresh();
        this.setButtonEnabled(3, bl);
    }

    public int getTotalUploads() {
        return _totalUploads;
    }

    public int getCurrentUploads() {
        return ((UploadModel)this.DATA_MODEL).getCurrentUploads();
    }

    public int getActiveUploads() {
        return ((UploadModel)this.DATA_MODEL).getRowCount();
    }

    public void add(Object object) {
        int n;
        if (!this.DATA_MODEL.contains(object) && (n = this.DATA_MODEL.update(object)) == -1) {
            ++_totalUploads;
            super.add(object);
        }
    }

    public void remove(Object object) {
        int n = ((Uploader)object).getState();
        if (AbstractTableMediator.SETTINGS.getClearCompletedUpload() && (n == 4 || n == 6 || n == 2 || n == 5 || n == 7 || n == 1)) {
            int n2 = this.DATA_MODEL.getRow(object);
            if (n2 != -1) {
                ((UploadDataLine)this.DATA_MODEL.get(n2)).setPersistConnection(true);
                super.removeRow(n2);
            }
        } else {
            UploadDataLine uploadDataLine = (UploadDataLine)this.DATA_MODEL.get(object);
            if (uploadDataLine != null) {
                uploadDataLine.setEndTime(System.currentTimeMillis());
            }
        }
    }

    public void removeSelection() {
        int[] nArray = this.TABLE.getSelectedRows();
        Arrays.sort(nArray);
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = nArray[n];
            this.DATA_MODEL.get(n2).cleanup();
            --n;
        }
    }

    void chatWithSelectedUploads() {
        RouterService routerService = GUIMediator.instance().getRouter();
        int[] nArray = this.TABLE.getSelectedRows();
        int n = 0;
        while (n < nArray.length) {
            DataLine dataLine = this.DATA_MODEL.get(nArray[n]);
            Uploader uploader = (Uploader)dataLine.getInitializeObject();
            if (uploader.isChatEnabled()) {
                String string = uploader.getHost();
                int n2 = uploader.getGnutellaPort();
                RouterService.createChat(string, n2);
            }
            ++n;
        }
    }

    void browseWithSelectedUploads() {
        boolean bl = false;
        int[] nArray = this.TABLE.getSelectedRows();
        HashSet hashSet = new HashSet(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            DataLine dataLine = this.DATA_MODEL.get(nArray[n]);
            Uploader uploader = (Uploader)dataLine.getInitializeObject();
            if (uploader.isBrowseHostEnabled()) {
                String string = uploader.getHost();
                int n2 = uploader.getGnutellaPort();
                if (!hashSet.contains(string)) {
                    SearchMediator.doBrowseHost(string, n2, null);
                    hashSet.add(string);
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            GUIMediator.instance().setWindow(0);
        }
    }

    public void handleMouseDoubleClick(Point point) {
    }

    void clearCompletedUploads() {
        ((UploadModel)this.DATA_MODEL).clearCompleted();
        this.clearSelection();
        this.setButtonEnabled(3, false);
    }

    public void handleSelection(int n) {
        UploadDataLine uploadDataLine = (UploadDataLine)this.DATA_MODEL.get(n);
        boolean bl = uploadDataLine.isChatEnabled();
        boolean bl2 = uploadDataLine.isBrowseEnabled();
        this.setButtonEnabled(0, true);
        this.setButtonEnabled(1, bl);
        this.setButtonEnabled(2, bl2);
        this.setPopupItemEnabled(0, true);
        this.setPopupItemEnabled(1, bl);
        this.setPopupItemEnabled(2, bl2);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
        this.setButtonEnabled(1, false);
        this.setButtonEnabled(2, false);
        this.setPopupItemEnabled(0, false);
        this.setPopupItemEnabled(1, false);
        this.setPopupItemEnabled(2, false);
    }
}

