/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.security.Cookies;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public abstract class AuthenticationHandshakeResponder
implements HandshakeResponder {
    private final Cookies COOKIES = Cookies.instance();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private ConnectionManager _manager;
    private String _host = null;
    private boolean _cookieUsed = false;
    private boolean _authenticated = false;
    private HandshakeResponse _beforeAuthenticationRequest = null;

    public AuthenticationHandshakeResponder(ConnectionManager connectionManager, String string) {
        this._manager = connectionManager;
        this._host = string;
    }

    public HandshakeResponse respond(HandshakeResponse handshakeResponse, boolean bl) throws IOException {
        if (this._beforeAuthenticationRequest == null) {
            this._beforeAuthenticationRequest = handshakeResponse;
        }
        if (bl) {
            return this.respondOutgoing(handshakeResponse);
        }
        return this.respondIncoming(handshakeResponse);
    }

    protected String getRemoteIP() {
        return this._host;
    }

    private HandshakeResponse respondIncoming(HandshakeResponse handshakeResponse) throws IOException {
        if (this._authenticated || !this.SETTINGS.acceptAuthenticatedConnectionsOnly()) {
            return this.respondUnauthenticated(handshakeResponse, false);
        }
        return this.respondIncomingAuthenticate(handshakeResponse);
    }

    private HandshakeResponse respondIncomingAuthenticate(HandshakeResponse handshakeResponse) throws IOException {
        Set set = this.getDomainsAuthenticated(handshakeResponse.getHeaders());
        if (set == null) {
            return new HandshakeResponse(401, "Unauthorized", null);
        }
        this._authenticated = true;
        HandshakeResponse handshakeResponse2 = this.respondUnauthenticated(this._beforeAuthenticationRequest, false);
        ((Hashtable)handshakeResponse2.getHeaders()).put("X-Domains-Authenticated", StringUtils.getEntriesAsString(set));
        return handshakeResponse2;
    }

    private Set getDomainsAuthenticated(Properties properties) {
        return this._manager.getAuthenticator().authenticate(properties.getProperty("X-Username"), properties.getProperty("X-Password"), null);
    }

    private HandshakeResponse respondOutgoing(HandshakeResponse handshakeResponse) throws IOException {
        if (handshakeResponse.getStatusCode() != 401) {
            return this.respondUnauthenticated(handshakeResponse, true);
        }
        return this.respondOutgoingWithAuthentication(handshakeResponse);
    }

    private HandshakeResponse respondOutgoingWithAuthentication(HandshakeResponse handshakeResponse) throws IOException {
        int n = 200;
        String string = "OK";
        Properties properties = new Properties();
        User user = this.getUserInfo();
        if (user == null || user.getUsername().trim().equals("")) {
            n = 503;
            string = "Unable To Authenticate";
        } else {
            n = 200;
            string = "AUTHENTICATING";
            ((Hashtable)properties).put("X-Username", user.getUsername());
            ((Hashtable)properties).put("X-Password", user.getPassword());
            this.COOKIES.putCookie(this._host, user);
        }
        return new HandshakeResponse(n, string, properties);
    }

    private User getUserInfo() {
        User user = null;
        if (!this._cookieUsed) {
            this._cookieUsed = true;
            if (this._host != null) {
                user = this.COOKIES.getUserInfo(this._host);
            }
        }
        if (user == null) {
            // empty if block
        }
        return user;
    }

    protected void addHostAddresses(Properties properties, ConnectionManager connectionManager) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Iterator iterator = connectionManager.getNormalHosts(10);
        while (iterator.hasNext()) {
            object = (Endpoint)iterator.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(((Endpoint)object).getHostname());
            stringBuffer.append(":");
            stringBuffer.append(((Endpoint)object).getPort());
        }
        ((Hashtable)properties).put("X-Try", stringBuffer.toString());
        object = connectionManager.getSupernodeEndpoints();
        if (object.size() < 0) {
            return;
        }
        stringBuffer = new StringBuffer();
        bl = true;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Endpoint endpoint = (Endpoint)iterator2.next();
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(endpoint.getHostname());
            stringBuffer.append(":");
            stringBuffer.append(endpoint.getPort());
        }
        ((Hashtable)properties).put("X-Try-Ultrapeers", stringBuffer.toString());
    }

    protected abstract HandshakeResponse respondUnauthenticated(HandshakeResponse var1, boolean var2) throws IOException;
}

