/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import java.util.Properties;

public class HandshakeResponse {
    public static final int OK = 200;
    public static final String OK_MESSAGE = "OK";
    public static final int SHIELDED = 503;
    public static final String SHIELDED_MESSAGE = "I am a shielded leaf node";
    public static final int SLOTS_FULL = 503;
    public static final String SLOTS_FULL_MESSAGE = "Service unavailable";
    public static final int DEFAULT_BAD_STATUS_CODE = 503;
    public static final String DEFAULT_BAD_STATUS_MESSAGE = "Service Not Available";
    public static final int UNAUTHORIZED_CODE = 401;
    public static final String UNAUTHORIZED_MESSAGE = "Unauthorized";
    public static final String UNABLE_TO_AUTHENTICATE = "Unable To Authenticate";
    public static final String AUTHENTICATING = "AUTHENTICATING";
    private int statusCode;
    private String statusMessage;
    private Properties headers;

    public HandshakeResponse() {
        this.statusCode = 200;
        this.statusMessage = OK_MESSAGE;
        this.headers = null;
    }

    public HandshakeResponse(Properties properties) {
        this.statusCode = 200;
        this.statusMessage = OK_MESSAGE;
        this.headers = properties;
    }

    public HandshakeResponse(int n, String string, Properties properties) {
        this.statusCode = n;
        this.statusMessage = string;
        this.headers = properties;
    }

    public HandshakeResponse(String string, Properties properties) {
        try {
            int n = string.indexOf(" ");
            this.statusCode = Integer.parseInt(string.substring(0, n).trim());
            this.statusMessage = string.substring(n).trim();
        }
        catch (Exception exception) {
            this.statusCode = 503;
            this.statusMessage = DEFAULT_BAD_STATUS_MESSAGE;
        }
        this.headers = properties;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean notOKStatusCode() {
        return this.statusCode != 200;
    }

    public String getStatusLine() {
        return new String(this.statusCode + " " + this.statusMessage);
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public String toString() {
        return "<" + this.statusCode + ", " + this.statusMessage + ">";
    }
}

