/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.AuthenticationHandshakeResponder;
import com.limegroup.gnutella.handshaking.ConnectionHandshakeHeaders;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.SupernodeProperties;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class SupernodeHandshakeResponder
extends AuthenticationHandshakeResponder {
    private ConnectionManager _manager;

    public SupernodeHandshakeResponder(ConnectionManager connectionManager, String string) {
        super(connectionManager, string);
        this._manager = connectionManager;
    }

    protected HandshakeResponse respondUnauthenticated(HandshakeResponse handshakeResponse, boolean bl) throws IOException {
        if (!bl) {
            SupernodeProperties supernodeProperties = new SupernodeProperties(this.getRemoteIP());
            ((Hashtable)supernodeProperties).put("X-Ultrapeer-Needed", new Boolean(this._manager.supernodeNeeded()).toString());
            ((Hashtable)supernodeProperties).put("Listen-IP", Message.ip2string(RouterService.getAddress()) + ":" + RouterService.getPort());
            this.addHostAddresses(supernodeProperties, this._manager);
            if (this.reject(bl, handshakeResponse.getHeaders())) {
                return new HandshakeResponse(503, "Service unavailable", supernodeProperties);
            }
            return new HandshakeResponse(supernodeProperties);
        }
        Properties properties = new Properties();
        if (!this._manager.allowConnection(bl, handshakeResponse.getHeaders().getProperty("X-Ultrapeer"), handshakeResponse.getHeaders().getProperty("User-Agent"))) {
            return new HandshakeResponse(503, "Service unavailable", properties);
        }
        String string = handshakeResponse.getHeaders().getProperty("X-Ultrapeer-Needed");
        if (string != null && !Boolean.valueOf(string).booleanValue() && this._manager.allowClientMode()) {
            ((Hashtable)properties).put("X-Ultrapeer", "False");
        }
        return new HandshakeResponse(properties);
    }

    private boolean reject(boolean bl, Properties properties) {
        String string = properties.getProperty("User-Agent");
        String string2 = properties.getProperty("X-Ultrapeer");
        boolean bl2 = ConnectionHandshakeHeaders.isTrue(string2);
        boolean bl3 = this._manager.allowConnection(bl, string2, string);
        boolean bl4 = this._manager.allowConnection(bl, "false", string);
        return !bl3 && (!bl2 || !bl4);
    }
}

