/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class HTTPUtils {
    private static final String CRLF = "\r\n";
    private static final String COLON_SPACE = ": ";
    private static final String COLON = ":";

    private HTTPUtils() {
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, OutputStream outputStream) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (outputStream == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue);
        outputStream.write(string.getBytes());
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
        }
    }

    public static void writeHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue, Writer writer) throws IOException {
        if (hTTPHeaderName == null) {
            throw new NullPointerException("null name in writing http header");
        }
        if (hTTPHeaderValue == null) {
            throw new NullPointerException("null value in writing http header: " + hTTPHeaderName);
        }
        if (writer == null) {
            throw new NullPointerException("null os in writing http header: " + hTTPHeaderName);
        }
        String string = HTTPUtils.createHeader(hTTPHeaderName, hTTPHeaderValue);
        writer.write(string);
        if (!CommonUtils.isJava118()) {
            BandwidthStat.HTTP_HEADER_UPSTREAM_BANDWIDTH.addData(string.length());
        }
    }

    private static String createHeader(HTTPHeaderName hTTPHeaderName, HTTPHeaderValue hTTPHeaderValue) throws IOException {
        if (hTTPHeaderName == null || hTTPHeaderValue == null) {
            throw new NullPointerException("null value in creating http header");
        }
        String string = hTTPHeaderName.httpStringValue();
        String string2 = hTTPHeaderValue.httpStringValue();
        if (string == null || string2 == null) {
            throw new NullPointerException("null value in creating http header");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(COLON_SPACE);
        stringBuffer.append(string2);
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }

    public static String extractHeaderValue(String string) {
        int n = string.indexOf(COLON);
        if (n <= 0) {
            return null;
        }
        return string.substring(n + 1).trim();
    }
}

