/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.util.COBSUtil;
import com.limegroup.gnutella.util.StringComparator;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.io.OutputStream;

public class GGEP {
    public static final String GGEP_HEADER_BROWSE_HOST = "BH";
    public static final String GGEP_HEADER_DAILY_AVERAGE_UPTIME = "DU";
    public static final String GGEP_HEADER_UNICAST_SUPPORT = "GUE";
    public static final String GGEP_HEADER_VENDOR_INFO = "VC";
    public static final String GGEP_HEADER_UP_SUPPORT = "UP";
    public static final int MAX_KEY_SIZE_IN_BYTES = 15;
    public static final int MAX_VALUE_SIZE_IN_BYTES = 262143;
    public static final byte GGEP_PREFIX_MAGIC_NUMBER = -61;
    private Map _props = new TreeMap(new StringComparator());
    public boolean notNeedCOBS = false;
    private volatile int hashCode = 0;
    private static final boolean debugOn = false;

    public GGEP(boolean bl) {
        this.notNeedCOBS = bl;
    }

    public GGEP(byte[] byArray, int n, int[] nArray) throws BadGGEPBlockException {
        if (byArray.length < 4) {
            throw new BadGGEPBlockException();
        }
        if (byArray[n] != -61) {
            throw new BadGGEPBlockException();
        }
        boolean bl = false;
        int n2 = n + 1;
        while (!bl) {
            try {
                this.sanityCheck(byArray[n2]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            bl = this.isLastExtension(byArray[n2]);
            boolean bl2 = this.isEncoded(byArray[n2]);
            boolean bl3 = this.isCompressed(byArray[n2]);
            int n3 = this.deriveHeaderLength(byArray[n2]);
            ++n2;
            String string = null;
            try {
                string = new String(byArray, n2, n3);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            int[] nArray2 = new int[1];
            int n4 = this.deriveDataLength(byArray, n2 += n3, nArray2);
            byte[] byArray2 = null;
            n2 += nArray2[0];
            if (n4 > 0) {
                byte[] byArray3 = new byte[n4];
                try {
                    System.arraycopy(byArray, n2, byArray3, 0, n4);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new BadGGEPBlockException();
                }
                if (bl2) {
                    byte[] byArray4 = COBSUtil.cobsDecode(byArray3);
                    byArray3 = new byte[byArray4.length - 1];
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length - 1);
                }
                if (bl3) continue;
                byArray2 = byArray3;
                n2 += n4;
            }
            this._props.put(string, byArray2);
        }
        if (nArray != null && nArray.length > 0) {
            nArray[0] = n2;
        }
    }

    private void sanityCheck(byte by) throws BadGGEPBlockException {
        if ((by & 0x10) != 0) {
            throw new BadGGEPBlockException();
        }
    }

    private boolean isLastExtension(byte by) {
        boolean bl = false;
        if ((by & 0x80) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isEncoded(byte by) {
        boolean bl = false;
        if ((by & 0x40) != 0) {
            bl = true;
        }
        return bl;
    }

    private boolean isCompressed(byte by) {
        boolean bl = false;
        if ((by & 0x20) != 0) {
            bl = true;
        }
        return bl;
    }

    private int deriveHeaderLength(byte by) throws BadGGEPBlockException {
        int n = 0;
        n = by & 0xF;
        if (n == 0) {
            throw new BadGGEPBlockException();
        }
        return n;
    }

    private int deriveDataLength(byte[] byArray, int n, int[] nArray) throws BadGGEPBlockException {
        byte by;
        int n2 = 0;
        int n3 = 0;
        do {
            try {
                by = byArray[n++];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new BadGGEPBlockException();
            }
            n2 = n2 << 6 | by & 0x3F;
            if (++n3 <= 3) continue;
            throw new BadGGEPBlockException();
        } while (64 != (by & 0x40));
        nArray[0] = n3;
        return n2;
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.getHeaders().size() > 0) {
            outputStream.write(-61);
            Iterator iterator = this.getHeaders().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                byte[] byArray = (byte[])this._props.get(string);
                int n = 0;
                boolean bl = this.shouldCOBSEncode(byArray);
                if (byArray != null) {
                    if (bl) {
                        byArray = COBSUtil.cobsEncode(byArray);
                    }
                    n = byArray.length;
                }
                this.writeHeader(string, n, !iterator.hasNext(), outputStream, bl);
                if (n <= 0) continue;
                outputStream.write(byArray);
            }
        }
    }

    private final boolean shouldCOBSEncode(byte[] byArray) {
        return !this.notNeedCOBS && this.containsNull(byArray);
    }

    private void writeHeader(String string, int n, boolean bl, OutputStream outputStream, boolean bl2) throws IOException {
        int n2;
        int n3;
        boolean bl3 = false;
        int n4 = 0;
        if (bl) {
            n4 |= 0x80;
        }
        if (bl2) {
            n4 |= 0x40;
        }
        if (bl3) {
            n4 |= 0x20;
        }
        outputStream.write(n4 |= string.getBytes().length);
        outputStream.write(string.getBytes());
        int n5 = n & 0x3F000;
        if (n5 != 0) {
            n3 = 0x80 | (n5 >>= 12);
            outputStream.write(n3);
        }
        if ((n2 = n & 0xFC0) != 0) {
            n3 = 0x80 | (n2 >>= 6);
            outputStream.write(n3);
        }
        int n6 = n & 0x3F;
        n3 = 0x40 | n6;
        outputStream.write(n3);
    }

    public static GGEP[] read(byte[] byArray, int n) throws BadGGEPBlockException {
        GGEP[] gGEPArray = null;
        ArrayList arrayList = new ArrayList();
        int[] nArray = new int[]{n};
        while (byArray.length > nArray[0] && byArray[nArray[0]] == -61) {
            arrayList.add(new GGEP(byArray, nArray[0], nArray));
        }
        Object[] objectArray = arrayList.toArray();
        gGEPArray = new GGEP[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            gGEPArray[n2] = (GGEP)objectArray[n2];
            ++n2;
        }
        return gGEPArray;
    }

    public void put(String string, byte[] byArray) throws IllegalArgumentException {
        this.validateKey(string);
        this.validateValue(byArray);
        this._props.put(string, byArray);
    }

    public void put(String string, String string2) throws IllegalArgumentException {
        this.put(string, string2 == null ? null : string2.getBytes());
    }

    public void put(String string, int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Negative value");
        }
        this.put(string, ByteOrder.int2minLeb(n));
    }

    public void put(String string) throws IllegalArgumentException {
        this.put(string, (byte[])null);
    }

    public byte[] getBytes(String string) throws BadGGEPPropertyException {
        byte[] byArray = (byte[])this._props.get(string);
        if (byArray == null) {
            throw new BadGGEPPropertyException();
        }
        return byArray;
    }

    public String getString(String string) throws BadGGEPPropertyException {
        return new String(this.getBytes(string));
    }

    public int getInt(String string) throws BadGGEPPropertyException {
        byte[] byArray = this.getBytes(string);
        if (byArray.length < 1) {
            throw new BadGGEPPropertyException("No bytes");
        }
        if (byArray.length > 4) {
            throw new BadGGEPPropertyException("Integer too big");
        }
        return ByteOrder.leb2int(byArray, 0, byArray.length);
    }

    public boolean hasKey(String string) {
        return this._props.containsKey(string);
    }

    public Set getHeaders() {
        return this._props.keySet();
    }

    private void validateKey(String string) throws IllegalArgumentException {
        byte[] byArray = string.getBytes();
        if (string == null || string.equals("") || byArray.length > 15 || this.containsNull(byArray)) {
            throw new IllegalArgumentException();
        }
    }

    private void validateValue(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            return;
        }
        if (byArray.length > 262143) {
            throw new IllegalArgumentException();
        }
    }

    private boolean containsNull(byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                if (byArray[n] == 0) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GGEP)) {
            return false;
        }
        return this.subset((GGEP)object) && ((GGEP)object).subset(this);
    }

    private boolean subset(GGEP gGEP) {
        Iterator iterator = this._props.keySet().iterator();
        while (iterator.hasNext()) {
            byte[] byArray;
            String string = (String)iterator.next();
            byte[] byArray2 = (byte[])this._props.get(string);
            if (byArray2 == null != ((byArray = (byte[])gGEP._props.get(string)) == null)) {
                return false;
            }
            if (byArray2 == null || Arrays.equals(byArray2, byArray)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 37 * this._props.hashCode();
        }
        return this.hashCode;
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            int n2 = ByteOrder.ubyte2int(byArray[n]);
            String string = Integer.toHexString(n2);
            while (string.length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString().toUpperCase();
    }

    private void debug(String string) {
    }
}

