/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.messages.GGEP;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class GGEPUtil {
    private static byte[] standardGGEP;
    private static byte[] qrGGEP;

    public static byte[] getQRGGEP(boolean bl) {
        byte[] byArray = standardGGEP;
        if (bl) {
            byArray = qrGGEP;
        }
        return byArray;
    }

    public static boolean allowsBrowseHost(GGEP[] gGEPArray) {
        boolean bl = false;
        int n = 0;
        while (gGEPArray != null && n < gGEPArray.length && !bl) {
            Set set = gGEPArray[n].getHeaders();
            bl = set.contains("BH");
            ++n;
        }
        return bl;
    }

    static {
        GGEP gGEP;
        standardGGEP = new byte[0];
        qrGGEP = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP = new GGEP(false);
            gGEP.write(byteArrayOutputStream);
            standardGGEP = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byteArrayOutputStream.reset();
        try {
            gGEP = new GGEP(false);
            gGEP.put("BH");
            gGEP.write(byteArrayOutputStream);
            qrGGEP = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.that(qrGGEP != null);
    }
}

