/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.mp3.MP3Info;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ID3Reader {
    private static final String schemaURI = "http://www.limewire.com/schemas/audio.xsd";
    private final String KEY_PREFIX = "audios__audio__";
    private final String TRACK_KEY = "audios__audio__track__";
    private final String ARTIST_KEY = "audios__audio__artist__";
    private final String ALBUM_KEY = "audios__audio__album__";
    private final String TITLE_KEY = "audios__audio__title__";
    private final String GENRE_KEY = "audios__audio__genre__";
    private final String YEAR_KEY = "audios__audio__year__";
    private final String COMMENTS_KEY = "audios__audio__comments__";
    private final String BITRATE_KEY = "audios__audio__bitrate__";
    private final String SECONDS_KEY = "audios__audio__seconds__";

    public String readDocument(File file, boolean bl) throws IOException {
        String string;
        Object[] objectArray = this.parseFile(file);
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[1];
        String string4 = (String)objectArray[2];
        String string5 = (String)objectArray[3];
        String string6 = (String)objectArray[5];
        short s = (Short)objectArray[4];
        short s2 = (Short)objectArray[6];
        int n = (Integer)objectArray[7];
        int n2 = (Integer)objectArray[8];
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            this.appendStrings("<audios noNamespaceSchemaLocation=\"", schemaURI, stringBuffer);
            stringBuffer.append("><audio ");
            string = file.getCanonicalPath();
            this.appendStrings(" identifier=\"", string, stringBuffer);
        }
        if (!string2.equals("")) {
            this.appendStrings(" title=\"", string2, stringBuffer);
        }
        if (!string3.equals("")) {
            this.appendStrings(" artist=\"", string3, stringBuffer);
        }
        if (!string4.equals("")) {
            this.appendStrings(" album=\"", string4, stringBuffer);
        }
        if (s > 0) {
            this.appendStrings(" track=\"", "" + s, stringBuffer);
        }
        if (!(string = ID3Reader.getGenreString(s2)).equals("")) {
            this.appendStrings(" genre=\"", string, stringBuffer);
        }
        if (!string5.equals("")) {
            this.appendStrings(" year=\"", string5, stringBuffer);
        }
        if (!string6.equals("")) {
            this.appendStrings(" comments=\"", string6, stringBuffer);
        }
        if (n > 0) {
            this.appendStrings(" bitrate=\"", "" + n, stringBuffer);
        }
        if (n2 > 0) {
            this.appendStrings(" seconds=\"", "" + n2, stringBuffer);
        }
        if (bl) {
            stringBuffer.append("/>");
            stringBuffer.append("</audios>");
        }
        return stringBuffer.toString();
    }

    public LimeXMLDocument readDocument(File file) throws IOException {
        Object[] objectArray = this.parseFile(file);
        short s = (Short)objectArray[4];
        short s2 = (Short)objectArray[6];
        int n = (Integer)objectArray[7];
        int n2 = (Integer)objectArray[8];
        String string = ID3Reader.getGenreString(s2);
        ArrayList arrayList = new ArrayList();
        if (!((String)objectArray[0]).equals("")) {
            arrayList.add(new NameValue("audios__audio__title__", objectArray[0]));
        }
        if (!((String)objectArray[1]).equals("")) {
            arrayList.add(new NameValue("audios__audio__artist__", objectArray[1]));
        }
        if (!((String)objectArray[2]).equals("")) {
            arrayList.add(new NameValue("audios__audio__album__", objectArray[2]));
        }
        if (!((String)objectArray[3]).equals("")) {
            arrayList.add(new NameValue("audios__audio__year__", objectArray[3]));
        }
        if (!((String)objectArray[5]).equals("")) {
            arrayList.add(new NameValue("audios__audio__comments__", objectArray[5]));
        }
        if (s > 0) {
            arrayList.add(new NameValue("audios__audio__track__", "" + s));
        }
        if (!string.equals("")) {
            arrayList.add(new NameValue("audios__audio__genre__", string));
        }
        if (n > 0) {
            arrayList.add(new NameValue("audios__audio__bitrate__", "" + n));
        }
        if (n2 > 0) {
            arrayList.add(new NameValue("audios__audio__seconds__", "" + n2));
        }
        return new LimeXMLDocument(arrayList, schemaURI);
    }

    private Object[] parseFile(File file) throws IOException {
        Object object;
        Object[] objectArray = new Object[9];
        objectArray[0] = "";
        objectArray[1] = "";
        objectArray[2] = "";
        objectArray[3] = "";
        objectArray[5] = "";
        objectArray[4] = new Short(-1);
        objectArray[6] = new Short(-1);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        if (l >= 128L) {
            randomAccessFile.seek(l - 128L);
            object = new byte[30];
            randomAccessFile.readFully((byte[])object, 0, 3);
            String string = new String((byte[])object, 0, 3);
            if (string.equals("TAG")) {
                int n;
                randomAccessFile.readFully((byte[])object, 0, 30);
                objectArray[0] = new String((byte[])object, 0, ID3Reader.getTrimmedLength((byte[])object, 30));
                randomAccessFile.readFully((byte[])object, 0, 30);
                objectArray[1] = new String((byte[])object, 0, ID3Reader.getTrimmedLength((byte[])object, 30));
                randomAccessFile.readFully((byte[])object, 0, 30);
                objectArray[2] = new String((byte[])object, 0, ID3Reader.getTrimmedLength((byte[])object, 30));
                randomAccessFile.readFully((byte[])object, 0, 4);
                objectArray[3] = new String((byte[])object, 0, ID3Reader.getTrimmedLength((byte[])object, 4));
                randomAccessFile.readFully((byte[])object, 0, 30);
                if (object[28] == false) {
                    objectArray[4] = new Short((short)ByteOrder.ubyte2int((byte)object[29]));
                    n = 28;
                } else {
                    objectArray[4] = new Short(0);
                    n = 3;
                }
                objectArray[5] = new String((byte[])object, 0, ID3Reader.getTrimmedLength((byte[])object, n));
                randomAccessFile.readFully((byte[])object, 0, 1);
                objectArray[6] = new Short((short)ByteOrder.ubyte2int((byte)object[0]));
            }
        }
        object = new MP3Info(file.getCanonicalPath());
        objectArray[7] = new Integer(((MP3Info)object).getBitRate());
        objectArray[8] = new Integer((int)((MP3Info)object).getLengthInSeconds());
        randomAccessFile.close();
        return objectArray;
    }

    private void appendStrings(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append(string);
        stringBuffer.append(string2);
        stringBuffer.append("\"");
    }

    private static int getTrimmedLength(byte[] byArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0 && (byArray[n2] == 0 || byArray[n2] == 32)) {
            --n2;
        }
        int n3 = 0;
        while (n3 <= n2) {
            if (byArray[n3] == 0) {
                byArray[n3] = 32;
            }
            ++n3;
        }
        return n2 + 1;
    }

    public static String getGenreString(short s) {
        switch (s) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }
}

