/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.ArrayList;

public class HashFunction {
    private static final double A = (Math.sqrt(5.0) - 1.0) / 2.0;
    private static final long TWO_31 = 0x80000000L;
    private static final int A_INT = 1327217884;

    private static int hashFast(int n, byte by) {
        long l = (long)n * 1327217884L;
        long l2 = l << 32;
        return (int)(l2 >>>= 32 + (32 - by));
    }

    public static int hash(String string, byte by) {
        return HashFunction.hash(string, 0, string.length(), by);
    }

    public static int hash(String string, int n, int n2, byte by) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n5 < n2) {
            int n6 = Character.toLowerCase(string.charAt(n5)) & 0xFF;
            n3 ^= (n6 <<= n4 * 8);
            n4 = (n4 + 1) % 4;
            ++n5;
        }
        return HashFunction.hashFast(n3, by);
    }

    public static String[] keywords(String string) {
        return StringUtils.split(string.toLowerCase(), " -._+/*()\\");
    }

    public static int keywordStart(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) < 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static int keywordEnd(String string, int n) {
        while (n < string.length()) {
            char c = string.charAt(n);
            if (" -._+/*()\\".indexOf(c) >= 0) {
                return n;
            }
            ++n;
        }
        return string.length();
    }

    public static String[] getPrefixes(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            int n2 = stringArray[n].length();
            if (n2 > 4) {
                arrayList.add(stringArray[n].substring(0, n2 - 1));
                arrayList.add(stringArray[n].substring(0, n2 - 2));
            }
            ++n;
        }
        String[] stringArray2 = new String[arrayList.size()];
        int n3 = 0;
        while (n3 < arrayList.size()) {
            stringArray2[n3] = (String)arrayList.get(n3);
            ++n3;
        }
        return stringArray2;
    }
}

