/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.sun.java.util.collections.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PatchTableMessage
extends RouteTableMessage {
    private short sequenceNumber;
    private short sequenceSize;
    private byte compressor;
    private byte entryBits;
    private byte[] data;
    public static final byte COMPRESSOR_NONE = 0;
    public static final byte COMPRESSOR_DEFLATE = 1;

    public PatchTableMessage(short s, short s2, byte by, byte by2, byte[] byArray, int n, int n2) {
        super((byte)1, 5 + (n2 - n), (byte)1);
        this.sequenceNumber = s;
        this.sequenceSize = s2;
        this.compressor = by;
        this.entryBits = by2;
        this.data = new byte[n2 - n];
        System.arraycopy(byArray, n, this.data, 0, this.data.length);
    }

    protected void writePayloadData(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4 + this.data.length];
        byArray[0] = (byte)this.sequenceNumber;
        byArray[1] = (byte)this.sequenceSize;
        byArray[2] = this.compressor;
        byArray[3] = this.entryBits;
        System.arraycopy(this.data, 0, byArray, 4, this.data.length);
        outputStream.write(byArray);
    }

    protected PatchTableMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2.length, (byte)1);
        Assert.that(byArray2[0] == 1);
        this.sequenceNumber = (short)ByteOrder.ubyte2int(byArray2[1]);
        this.sequenceSize = (short)ByteOrder.ubyte2int(byArray2[2]);
        if (this.sequenceNumber < 1 || this.sequenceSize < 1 || this.sequenceNumber > this.sequenceSize) {
            throw new BadPacketException("Bad sequence/size: " + this.sequenceNumber + "/" + this.sequenceSize);
        }
        this.compressor = byArray2[3];
        if (this.compressor != 0 && this.compressor != 1) {
            throw new BadPacketException("Bad compressor: " + this.compressor);
        }
        this.entryBits = byArray2[4];
        if (this.entryBits < 0) {
            throw new BadPacketException("Negative entryBits: " + this.entryBits);
        }
        this.data = new byte[byArray2.length - 5];
        System.arraycopy(byArray2, 5, this.data, 0, this.data.length);
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public short getSequenceSize() {
        return this.sequenceSize;
    }

    public byte getCompressor() {
        return this.compressor;
    }

    public byte getEntryBits() {
        return this.entryBits;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{PATCH, Sequence: " + this.getSequenceNumber() + "/" + this.getSequenceSize() + ", Bits: " + this.entryBits + ", Compr: " + this.getCompressor() + ", [");
        stringBuffer.append("<" + this.data.length + " bytes>");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        PatchTableMessage patchTableMessage = new PatchTableMessage(3, 255, 0, 2, new byte[]{0, -85, -51, 0}, 1, 3);
        Assert.that(patchTableMessage.getVariant() == 1);
        Assert.that(patchTableMessage.getTTL() == 1);
        Assert.that(patchTableMessage.getSequenceSize() == 255);
        Assert.that(patchTableMessage.getSequenceNumber() == 3);
        Assert.that(patchTableMessage.getCompressor() == 0);
        Assert.that(patchTableMessage.getEntryBits() == 2);
        Assert.that(Arrays.equals(patchTableMessage.getData(), new byte[]{-85, -51}));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            patchTableMessage.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        Assert.that(patchTableMessage.getVariant() == 1);
        Assert.that(patchTableMessage.getTTL() == 1);
        Assert.that(patchTableMessage.getSequenceSize() == 255);
        Assert.that(patchTableMessage.getSequenceNumber() == 3);
        Assert.that(patchTableMessage.getCompressor() == 0);
        Assert.that(patchTableMessage.getEntryBits() == 2);
        Assert.that(Arrays.equals(patchTableMessage.getData(), new byte[]{-85, -51}));
        byte[] byArray = new byte[30];
        byArray[16] = 48;
        byArray[17] = 1;
        byArray[19] = 7;
        byArray[23] = 1;
        byArray[24] = 1;
        byArray[25] = -1;
        byArray[26] = 1;
        byArray[27] = 2;
        byArray[28] = -85;
        byArray[29] = -51;
        patchTableMessage = PatchTableMessage.read(byArray);
        Assert.that(patchTableMessage.getVariant() == 1);
        Assert.that(patchTableMessage.getTTL() == 1);
        Assert.that(patchTableMessage.getSequenceNumber() == 1);
        Assert.that(patchTableMessage.getSequenceSize() == 255, "Got: " + patchTableMessage.getSequenceSize());
        Assert.that(patchTableMessage.getCompressor() == 1);
        Assert.that(patchTableMessage.getEntryBits() == 2);
        Assert.that(patchTableMessage.getData().length == 2);
        Assert.that(patchTableMessage.getData()[0] == -85);
        Assert.that(patchTableMessage.getData()[1] == -51);
    }

    static PatchTableMessage read(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return (PatchTableMessage)Message.read(byteArrayInputStream);
        }
        catch (Exception exception) {
            Assert.that(false, "Bad message: " + exception);
            return null;
        }
    }
}

