/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.routing.PercentageStatisticValue;
import com.limegroup.gnutella.routing.StatisticValue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.NumberFormat;

public class StatisticsRecorder {
    private static final long WAIT_TIME = 1800000L;
    private static final String SERVLET_URL = "http://sparky.limewire.com:8081/update/servlet/AlphaTestStatsHandler";
    private static long nextTimeToSendStats = System.currentTimeMillis() + 1800000L;
    private static String clientID = SettingsManager.instance().getClientID();
    private static HashMap statistics = new HashMap();
    private static Object statisticsLock = new Object();
    private static NumberFormat nf = NumberFormat.getInstance();

    public static synchronized void addToAverage(String string, int n, String string2) {
        if (statistics.containsKey(string)) {
            StatisticValue statisticValue = (StatisticValue)statistics.get(string);
            statisticValue.addToSum(n);
        } else {
            statistics.put(string, new StatisticValue(n, true, string2));
        }
        if (System.currentTimeMillis() >= nextTimeToSendStats) {
            new StatisticsSenderThread().start();
            nextTimeToSendStats = System.currentTimeMillis() + 1800000L;
        }
    }

    public static synchronized void addToTotal(String string, int n, String string2) {
        if (statistics.containsKey(string)) {
            StatisticValue statisticValue = (StatisticValue)statistics.get(string);
            statisticValue.addToSum(n);
        } else {
            statistics.put(string, new StatisticValue(n, false, string2));
        }
        if (System.currentTimeMillis() >= nextTimeToSendStats) {
            new StatisticsSenderThread().start();
            nextTimeToSendStats = System.currentTimeMillis() + 1800000L;
        }
    }

    public static synchronized void addToPercentage(String string, int n, int n2) {
        if (statistics.containsKey(string)) {
            PercentageStatisticValue percentageStatisticValue = (PercentageStatisticValue)statistics.get(string);
            percentageStatisticValue.addToPercentage(n, n2);
        } else {
            statistics.put(string, new PercentageStatisticValue(n, n2));
        }
        if (System.currentTimeMillis() >= nextTimeToSendStats) {
            new StatisticsSenderThread().start();
            nextTimeToSendStats = System.currentTimeMillis() + 1800000L;
        }
    }

    static {
        nf.setMaximumFractionDigits(2);
    }

    private static class StatisticsSenderThread
    extends Thread {
        private StatisticsSenderThread() {
        }

        public void run() {
            try {
                URL uRL = new URL(StatisticsRecorder.SERVLET_URL);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setDoOutput(true);
                PrintWriter printWriter = new PrintWriter(uRLConnection.getOutputStream());
                printWriter.print("clientID=" + URLEncoder.encode(clientID) + "\n\n");
                printWriter.print(this.generateSendString());
                printWriter.close();
                InputStream inputStream = uRLConnection.getInputStream();
            }
            catch (Throwable throwable) {
                RouterService.error(throwable);
            }
        }

        private String generateSendString() {
            StringBuffer stringBuffer = new StringBuffer();
            Object object = statisticsLock;
            synchronized (object) {
                Set set = statistics.entrySet();
                Map.Entry[] entryArray = (Map.Entry[])set.toArray(new Map.Entry[set.size()]);
                int n = 0;
                while (n < entryArray.length) {
                    String string = (String)entryArray[n].getKey();
                    StatisticValue statisticValue = (StatisticValue)entryArray[n].getValue();
                    String string2 = null;
                    if (statisticValue instanceof PercentageStatisticValue) {
                        PercentageStatisticValue percentageStatisticValue = (PercentageStatisticValue)statisticValue;
                        String string3 = nf.format(percentageStatisticValue.calculatePercent());
                        string2 = new String(string3 + " " + statisticValue.getMetric());
                    } else {
                        string2 = statisticValue.isAverageStatistic() ? new String(statisticValue.calculateAverage() + " " + statisticValue.getMetric()) : new String(statisticValue.getTotal() + " " + statisticValue.getMetric());
                    }
                    stringBuffer.append(string + "=" + URLEncoder.encode(string2) + "\n");
                    ++n;
                }
                statistics.clear();
            }
            return stringBuffer.toString();
        }
    }
}

