/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.Serializable;

public class Cookies
implements Serializable {
    private Map _hostUserInfoMap = new HashMap();
    private static Cookies _instance = new Cookies();

    public static Cookies instance() {
        return _instance;
    }

    private void initialize() {
        try {
            this._hostUserInfoMap = this.readCookies();
        }
        catch (Exception exception) {
            this._hostUserInfoMap = new HashMap();
        }
    }

    protected Cookies() {
        this.initialize();
    }

    private Map readCookies() throws IOException, ClassNotFoundException {
        return FileUtils.readMap(SettingsManager.instance().getCookiesFile());
    }

    public synchronized User getUserInfo(String string) {
        return (User)this._hostUserInfoMap.get(string);
    }

    public synchronized void putCookie(String string, User user) {
        this._hostUserInfoMap.put(string, user);
    }

    public void save() {
        try {
            Map map;
            Cookies cookies = this;
            synchronized (cookies) {
                map = (Map)((HashMap)this._hostUserInfoMap).clone();
            }
            FileUtils.writeMap(SettingsManager.instance().getCookiesFile(), map);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String toString() {
        return this._hostUserInfoMap.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(Cookies.instance().toString());
    }
}

