/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.security;

import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.IOException;

public class UserManager {
    private Map _userMap = new HashMap();
    private static UserManager _instance = new UserManager();

    public static UserManager instance() {
        return _instance;
    }

    private void initialize() {
        try {
            this._userMap = UserManager.readUserMap();
        }
        catch (Exception exception) {
            this._userMap = new HashMap();
        }
    }

    private UserManager() {
        this.initialize();
    }

    private static void writeUserMap(Map map) throws IOException, ClassNotFoundException {
        FileUtils.writeMap(LimeXMLProperties.instance().getUserMapFile(), map);
    }

    private static Map readUserMap() throws IOException, ClassNotFoundException {
        return FileUtils.readMap(LimeXMLProperties.instance().getUserMapFile());
    }

    public synchronized User getUser(String string) {
        return (User)this._userMap.get(string);
    }

    public synchronized void putUser(User user) {
        this._userMap.put(user.getUsername(), user);
    }

    public synchronized String[] getAllUsers() {
        return (String[])this._userMap.keySet().toArray(new String[0]);
    }

    public synchronized void removeUser(String string) {
        this._userMap.remove(string);
    }

    public void save() {
        try {
            Map map;
            UserManager userManager = this;
            synchronized (userManager) {
                map = (Map)((HashMap)this._userMap).clone();
            }
            UserManager.writeUserMap(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        return this._userMap.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(UserManager.instance().toString());
    }
}

