/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.BooleanSetting;
import com.limegroup.gnutella.settings.ByteSetting;
import com.limegroup.gnutella.settings.ColorSetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.LongSetting;
import com.limegroup.gnutella.settings.StringSetting;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public final class SettingsFactory {
    protected final Properties DEFAULT_PROPS;
    protected final Properties PROPS;

    SettingsFactory(File file, Properties properties, Properties properties2) {
        this.DEFAULT_PROPS = properties;
        this.PROPS = properties2;
        this.reload(file);
    }

    static SettingsFactory createFromFile(File file, Properties properties) {
        return new SettingsFactory(file, properties, new Properties(properties));
    }

    public void reload(File file) {
        if (!file.isFile()) {
            return;
        }
        try {
            this.PROPS.load(new FileInputStream(file));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public StringSetting createStringSetting(String string, String string2) {
        return new StringSetting(this.DEFAULT_PROPS, this.PROPS, string, string2);
    }

    public BooleanSetting createBooleanSetting(String string, boolean bl) {
        return new BooleanSetting(this.DEFAULT_PROPS, this.PROPS, string, bl);
    }

    public IntSetting createIntSetting(String string, int n) {
        return new IntSetting(this.DEFAULT_PROPS, this.PROPS, string, n);
    }

    public ByteSetting createByteSetting(String string, byte by) {
        return new ByteSetting(this.DEFAULT_PROPS, this.PROPS, string, by);
    }

    public LongSetting createLongSetting(String string, long l) {
        return new LongSetting(this.DEFAULT_PROPS, this.PROPS, string, l);
    }

    public FileSetting createFileSetting(String string, File file) {
        File file2 = new File(file.getParent());
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return new FileSetting(this.DEFAULT_PROPS, this.PROPS, string, file);
    }

    public ColorSetting createColorSetting(String string, Color color) {
        return ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, string, color);
    }
}

