/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.settings.ColorSetting;
import com.limegroup.gnutella.settings.IntSetting;
import com.limegroup.gnutella.settings.SettingsFactory;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Expand;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class ThemeFileHandler {
    private static final Properties DEFAULT_PROPS = new Properties();
    private static SettingsFactory FACTORY;
    public static final StringSetting CONTROL_TEXT_FONT_NAME;
    public static final IntSetting CONTROL_TEXT_FONT_STYLE;
    public static final IntSetting CONTROL_TEXT_FONT_SIZE;
    public static final StringSetting SYSTEM_TEXT_FONT_NAME;
    public static final IntSetting SYSTEM_TEXT_FONT_STYLE;
    public static final IntSetting SYSTEM_TEXT_FONT_SIZE;
    public static final StringSetting USER_TEXT_FONT_NAME;
    public static final IntSetting USER_TEXT_FONT_STYLE;
    public static final IntSetting USER_TEXT_FONT_SIZE;
    public static final StringSetting MENU_TEXT_FONT_NAME;
    public static final IntSetting MENU_TEXT_FONT_STYLE;
    public static final IntSetting MENU_TEXT_FONT_SIZE;
    public static final StringSetting WINDOW_TITLE_FONT_NAME;
    public static final IntSetting WINDOW_TITLE_FONT_STYLE;
    public static final IntSetting WINDOW_TITLE_FONT_SIZE;
    public static final StringSetting SUB_TEXT_FONT_NAME;
    public static final IntSetting SUB_TEXT_FONT_STYLE;
    public static final IntSetting SUB_TEXT_FONT_SIZE;
    public static final ColorSetting PRIMARY1_COLOR;
    public static final ColorSetting PRIMARY2_COLOR;
    public static final ColorSetting PRIMARY3_COLOR;
    public static final ColorSetting SECONDARY1_COLOR;
    public static final ColorSetting SECONDARY2_COLOR;
    public static final ColorSetting SECONDARY3_COLOR;
    public static final ColorSetting WINDOW1_COLOR;
    public static final ColorSetting WINDOW2_COLOR;
    public static final ColorSetting WINDOW3_COLOR;
    public static final ColorSetting WINDOW4_COLOR;
    public static final ColorSetting WINDOW5_COLOR;
    public static final ColorSetting WINDOW6_COLOR;
    public static final ColorSetting WINDOW7_COLOR;
    public static final ColorSetting WINDOW8_COLOR;
    public static final ColorSetting WINDOW9_COLOR;
    public static final ColorSetting WINDOW10_COLOR;
    public static final ColorSetting WINDOW11_COLOR;
    public static final ColorSetting WINDOW12_COLOR;
    public static final ColorSetting TABLE_HEADER_BACKGROUND_COLOR;
    public static final ColorSetting TABLE_BACKGROUND_COLOR;
    public static final ColorSetting NOT_SHARING_LABEL_COLOR;
    public static final ColorSetting SEARCH_FADE_COLOR;
    public static final ColorSetting SEARCH_BUTTON_COLOR;
    public static final ColorSetting SEARCH_RESULT_SPEED_COLOR;
    public static final ColorSetting PLAYING_SONG_COLOR;
    public static final ColorSetting SEARCH_IP_COLOR;
    public static final ColorSetting SEARCH_PRIVATE_IP_COLOR;

    public static void reload() {
        File file = ThemeSettings.THEME_FILE.getValue();
        String string = file.getName();
        string = string.substring(0, string.length() - 5);
        File file2 = new File(new File(CommonUtils.getUserSettingsDir(), "themes"), string);
        File file3 = new File(file2, "theme.txt");
        if (!file2.isDirectory() || file2.lastModified() < file.lastModified() || !file3.isFile()) {
            file2.mkdirs();
            try {
                Expand.expandFile(file, file2);
            }
            catch (IOException iOException) {
                RouterService.error(iOException);
            }
        }
        ThemeFileHandler.handleFactory(file3);
        ThemeSettings.THEME_DIR.setValue(file2);
    }

    private static void handleFactory(File file) {
        if (FACTORY == null) {
            FACTORY = SettingsFactory.createFromFile(file, DEFAULT_PROPS);
        } else {
            FACTORY.reload(file);
        }
    }

    static {
        ThemeFileHandler.reload();
        CONTROL_TEXT_FONT_NAME = FACTORY.createStringSetting("CONTROL_TEXT_FONT_NAME", "dialog");
        CONTROL_TEXT_FONT_STYLE = FACTORY.createIntSetting("CONTROL_TEXT_FONT_STYLE", 1);
        CONTROL_TEXT_FONT_SIZE = FACTORY.createIntSetting("CONTROL_TEXT_FONT_SIZE", 11);
        SYSTEM_TEXT_FONT_NAME = FACTORY.createStringSetting("SYSTEM_TEXT_FONT_NAME", "dialog");
        SYSTEM_TEXT_FONT_STYLE = FACTORY.createIntSetting("SYSTEM_TEXT_FONT_STYLE", 0);
        SYSTEM_TEXT_FONT_SIZE = FACTORY.createIntSetting("SYSTEM_TEXT_FONT_SIZE", 11);
        USER_TEXT_FONT_NAME = FACTORY.createStringSetting("USER_TEXT_FONT_NAME", "dialog");
        USER_TEXT_FONT_STYLE = FACTORY.createIntSetting("USER_TEXT_FONT_STYLE", 0);
        USER_TEXT_FONT_SIZE = FACTORY.createIntSetting("USER_TEXT_FONT_SIZE", 11);
        MENU_TEXT_FONT_NAME = FACTORY.createStringSetting("MENU_TEXT_FONT_NAME", "dialog");
        MENU_TEXT_FONT_STYLE = FACTORY.createIntSetting("MENU_TEXT_FONT_STYLE", 1);
        MENU_TEXT_FONT_SIZE = FACTORY.createIntSetting("MENU_TEXT_FONT_SIZE", 11);
        WINDOW_TITLE_FONT_NAME = FACTORY.createStringSetting("WINDOW_TITLE_FONT_NAME", "dialog");
        WINDOW_TITLE_FONT_STYLE = FACTORY.createIntSetting("WINDOW_TITLE_FONT_STYLE", 1);
        WINDOW_TITLE_FONT_SIZE = FACTORY.createIntSetting("WINDOW_TITLE_FONT_SIZE", 11);
        SUB_TEXT_FONT_NAME = FACTORY.createStringSetting("SUB_TEXT_FONT_NAME", "dialog");
        SUB_TEXT_FONT_STYLE = FACTORY.createIntSetting("SUB_TEXT_FONT_STYLE", 0);
        SUB_TEXT_FONT_SIZE = FACTORY.createIntSetting("SUB_TEXT_FONT_SIZE", 10);
        PRIMARY1_COLOR = FACTORY.createColorSetting("PRIMARY1_COLOR", new Color(74, 110, 188));
        PRIMARY2_COLOR = FACTORY.createColorSetting("PRIMARY2_COLOR", new Color(135, 145, 170));
        PRIMARY3_COLOR = FACTORY.createColorSetting("PRIMARY3_COLOR", new Color(216, 225, 244));
        SECONDARY1_COLOR = FACTORY.createColorSetting("SECONDARY1_COLOR", new Color(50, 68, 107));
        SECONDARY2_COLOR = FACTORY.createColorSetting("SECONDARY2_COLOR", new Color(167, 173, 190));
        SECONDARY3_COLOR = FACTORY.createColorSetting("SECONDARY3_COLOR", new Color(199, 201, 209));
        WINDOW1_COLOR = FACTORY.createColorSetting("WINDOW1_COLOR", new Color(0, 0, 0));
        WINDOW2_COLOR = FACTORY.createColorSetting("WINDOW2_COLOR", new Color(199, 201, 209));
        WINDOW3_COLOR = FACTORY.createColorSetting("WINDOW3_COLOR", new Color(199, 201, 209));
        WINDOW4_COLOR = FACTORY.createColorSetting("WINDOW4_COLOR", new Color(0, 0, 0));
        WINDOW5_COLOR = FACTORY.createColorSetting("WINDOW5_COLOR", new Color(0, 0, 0));
        WINDOW6_COLOR = FACTORY.createColorSetting("WINDOW6_COLOR", new Color(255, 255, 255));
        WINDOW7_COLOR = FACTORY.createColorSetting("WINDOW7_COLOR", new Color(255, 255, 255));
        WINDOW8_COLOR = FACTORY.createColorSetting("WINDOW8_COLOR", new Color(0, 0, 0));
        WINDOW9_COLOR = FACTORY.createColorSetting("WINDOW9_COLOR", new Color(0, 0, 0));
        WINDOW10_COLOR = FACTORY.createColorSetting("WINDOW10_COLOR", new Color(0, 0, 0));
        WINDOW11_COLOR = FACTORY.createColorSetting("WINDOW11_COLOR", new Color(0, 0, 0));
        WINDOW12_COLOR = FACTORY.createColorSetting("WINDOW12_COLOR", new Color(199, 201, 209));
        TABLE_HEADER_BACKGROUND_COLOR = FACTORY.createColorSetting("TABLE_HEADER_BACKGROUND_COLOR", new Color(117, 142, 197));
        TABLE_BACKGROUND_COLOR = FACTORY.createColorSetting("TABLE_BACKGROUND_COLOR", new Color(255, 255, 255));
        NOT_SHARING_LABEL_COLOR = FACTORY.createColorSetting("NOT_SHARING_LABEL_COLOR", new Color(208, 0, 5));
        SEARCH_FADE_COLOR = FACTORY.createColorSetting("SEARCH_FADE_COLOR", new Color(135, 146, 185));
        SEARCH_BUTTON_COLOR = FACTORY.createColorSetting("SEARCH_BUTTON_COLOR", new Color(255, 255, 255));
        SEARCH_RESULT_SPEED_COLOR = FACTORY.createColorSetting("SEARCH_RESULT_SPEED_COLOR", new Color(7, 170, 0));
        PLAYING_SONG_COLOR = FACTORY.createColorSetting("PLAYING_SONG_COLOR", new Color(7, 170, 0));
        SEARCH_IP_COLOR = FACTORY.createColorSetting("SEARCH_IP_COLOR", new Color(0, 0, 0));
        SEARCH_PRIVATE_IP_COLOR = FACTORY.createColorSetting("SEARCH_PRIVATE_IP_COLOR", new Color(255, 0, 0));
    }
}

