/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.statistics.AdvancedKilobytesStatistic;
import com.limegroup.gnutella.statistics.AdvancedStatistic;
import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.statistics.StatisticsManager;

public abstract class AbstractStatHandler {
    public final Statistic NUMBER_STAT;
    public final Statistic BYTE_STAT;
    public final Statistic LIME_NUMBER_STAT;
    public final Statistic LIME_BYTE_STAT;
    public final Statistic BANDWIDTH_BYTE_STAT;
    protected static final StatisticsManager STATS_MANAGER = StatisticsManager.instance();
    private static final Statistic BANDWIDTH_BYTE_STAT_STUB = new AdvancedStatistic(){

        public void addData() {
        }
    };

    protected AbstractStatHandler(String string) {
        this.NUMBER_STAT = new AdvancedStatistic(string);
        this.BYTE_STAT = new AdvancedKilobytesStatistic(string);
        this.LIME_NUMBER_STAT = new AdvancedStatistic(string);
        this.LIME_BYTE_STAT = new AdvancedKilobytesStatistic(string);
        this.BANDWIDTH_BYTE_STAT = BANDWIDTH_BYTE_STAT_STUB;
    }

    protected AbstractStatHandler(Statistic statistic, Statistic statistic2, Statistic statistic3, Statistic statistic4, Statistic statistic5) {
        this.NUMBER_STAT = statistic;
        this.BYTE_STAT = statistic2;
        this.LIME_NUMBER_STAT = statistic3;
        this.LIME_BYTE_STAT = statistic4;
        this.BANDWIDTH_BYTE_STAT = statistic5;
    }

    protected AbstractStatHandler(Statistic statistic, Statistic statistic2, Statistic statistic3, Statistic statistic4) {
        this(statistic, statistic2, statistic3, statistic4, BANDWIDTH_BYTE_STAT_STUB);
    }

    public void addMessage(Message message) {
        if (!STATS_MANAGER.getRecordAdvancedStats()) {
            return;
        }
        this.NUMBER_STAT.incrementStat();
        this.BYTE_STAT.addData(message.getTotalLength());
        this.BANDWIDTH_BYTE_STAT.addData(message.getTotalLength());
        if (new GUID(message.getGUID()).isLimeGUID()) {
            this.LIME_NUMBER_STAT.incrementStat();
            this.LIME_BYTE_STAT.addData(message.getTotalLength());
        }
    }
}

