/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.statistics.StatisticsManager;
import com.limegroup.gnutella.util.IntBuffer;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.LinkedList;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.StringTokenizer;

public abstract class AbstractStatistic
implements Statistic {
    protected static final StatisticsManager STATS_MANAGER = StatisticsManager.instance();
    private IntBuffer _buffer;
    protected volatile int _current = 0;
    protected volatile double _total = 0.0;
    protected volatile int _totalStatsRecorded = 0;
    protected volatile double _max = 0.0;
    private Writer _writer;
    private boolean _writeStat = false;
    private int _numWriters = 0;
    private final Object BUFFER_LOCK = new Object();
    protected String _fileName;

    protected AbstractStatistic() {
    }

    public double getTotal() {
        return this._total;
    }

    public double getAverage() {
        return this._total / (double)this._totalStatsRecorded;
    }

    public double getMax() {
        return this._max;
    }

    public void incrementStat() {
        ++this._current;
        this._total += 1.0;
    }

    public void addData(int n) {
        this._current += n;
        this._total += (double)n;
    }

    public IntBuffer getStatHistory() {
        Object object = this.BUFFER_LOCK;
        synchronized (object) {
            this.initializeBuffer();
            IntBuffer intBuffer = this._buffer;
            return intBuffer;
        }
    }

    public void storeCurrentStat() {
        Object object = this.BUFFER_LOCK;
        synchronized (object) {
            this.initializeBuffer();
            this._buffer.addLast(this._current);
        }
        if ((double)this._current > this._max) {
            this._max = this._current;
        }
        if (this._writeStat && this._writer != null) {
            try {
                this._writer.write(Integer.toString(this._current));
                this._writer.write(",");
                this._writer.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this._current = 0;
        ++this._totalStatsRecorded;
    }

    public synchronized void setWriteStatToFile(boolean bl) {
        if (bl) {
            ++this._numWriters;
            this._writeStat = true;
            if (this._numWriters == 1) {
                try {
                    if (this._fileName == null || this._fileName.equals("")) {
                        Class<?> clazz = this.getClass().getSuperclass();
                        Class<?> clazz2 = this.getClass().getDeclaringClass();
                        LinkedList linkedList = new LinkedList();
                        if (clazz != null) {
                            linkedList.addAll(Arrays.asList(clazz.getFields()));
                        }
                        if (clazz2 != null) {
                            linkedList.addAll(Arrays.asList(clazz2.getFields()));
                        }
                        linkedList.addAll(Arrays.asList(this.getClass().getFields()));
                        Field[] fieldArray = (Field[])linkedList.toArray(new Field[0]);
                        int n = 0;
                        while (n < fieldArray.length) {
                            try {
                                Object object = fieldArray[n].get(null);
                                if (object.equals(this)) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(fieldArray[n].toString());
                                    while (stringTokenizer.hasMoreTokens()) {
                                        this._fileName = stringTokenizer.nextToken();
                                    }
                                    this._fileName = this._fileName.substring(34);
                                }
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                            ++n;
                        }
                    }
                    this._writer = new FileWriter(this._fileName, false);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (this._numWriters != 0) {
            --this._numWriters;
        }
        if (this._numWriters == 0) {
            this._writeStat = false;
            this._writer = null;
        }
    }

    private void initializeBuffer() {
        if (this._buffer == null) {
            this._buffer = new IntBuffer(200);
            int n = 0;
            while (n < 200) {
                this._buffer.addLast(0);
                ++n;
            }
        }
    }
}

