/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.statistics;

import com.limegroup.gnutella.statistics.BasicKilobytesStatistic;
import com.limegroup.gnutella.statistics.Statistic;

public class BandwidthStat
extends BasicKilobytesStatistic {
    public static final Statistic UPSTREAM_BANDWIDTH = new BandwidthStat();
    public static final Statistic DOWNSTREAM_BANDWIDTH = new BandwidthStat();
    public static final Statistic HTTP_DOWNSTREAM_BANDWIDTH = new DownstreamBandwidthStat();
    public static final Statistic HTTP_UPSTREAM_BANDWIDTH = new UpstreamBandwidthStat();
    public static final Statistic HTTP_HEADER_DOWNSTREAM_BANDWIDTH = new DownstreamHTTPBandwidthStat();
    public static final Statistic HTTP_BODY_DOWNSTREAM_BANDWIDTH = new DownstreamHTTPBandwidthStat();
    public static final Statistic HTTP_HEADER_UPSTREAM_BANDWIDTH = new UpstreamHTTPBandwidthStat();
    public static final Statistic HTTP_BODY_UPSTREAM_BANDWIDTH = new UpstreamHTTPBandwidthStat();
    public static final Statistic GNUTELLA_DOWNSTREAM_BANDWIDTH = new DownstreamBandwidthStat();
    public static final Statistic GNUTELLA_UPSTREAM_BANDWIDTH = new UpstreamBandwidthStat();

    private BandwidthStat() {
    }

    private static class UpstreamHTTPBandwidthStat
    extends BandwidthStat {
        private UpstreamHTTPBandwidthStat() {
        }

        public void addData(int n) {
            super.addData(n);
            HTTP_UPSTREAM_BANDWIDTH.addData(n);
        }
    }

    private static class DownstreamHTTPBandwidthStat
    extends BandwidthStat {
        private DownstreamHTTPBandwidthStat() {
        }

        public void addData(int n) {
            super.addData(n);
            HTTP_DOWNSTREAM_BANDWIDTH.addData(n);
        }
    }

    private static class DownstreamBandwidthStat
    extends BandwidthStat {
        private DownstreamBandwidthStat() {
        }

        public void addData(int n) {
            super.addData(n);
            DOWNSTREAM_BANDWIDTH.addData(n);
        }
    }

    private static class UpstreamBandwidthStat
    extends BandwidthStat {
        private UpstreamBandwidthStat() {
        }

        public void addData(int n) {
            super.addData(n);
            UPSTREAM_BANDWIDTH.addData(n);
        }
    }
}

