/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.AbstractRemoteUpdateInfo;
import com.limegroup.gnutella.update.DisplayMessageUpdator;
import com.limegroup.gnutella.update.MultipleFileUpdator;
import com.limegroup.gnutella.update.NoUpdateUpdator;
import com.limegroup.gnutella.update.Updator;
import com.limegroup.gnutella.update.WebPageUpdator;
import com.limegroup.gnutella.util.URLDecoder;
import java.util.StringTokenizer;

public final class ClientRemoteUpdateInfo
extends AbstractRemoteUpdateInfo {
    private Updator _updator = new NoUpdateUpdator();

    final void addRemoteInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            this.handleKeyValuePair(stringTokenizer.nextToken());
        }
    }

    final Updator getUpdator() {
        return this._updator;
    }

    private final void handleKeyValuePair(String string) {
        if (string.startsWith("DIRECTIVE")) {
            this.setUpdator(string);
        } else if (string.startsWith("MESSAGE_TO_DISPLAY")) {
            String string2 = this.getUpdateValue(string);
            this._updator.setMessageToDisplay(string2);
        } else if (string.startsWith("UPDATE_URL")) {
            String string3 = this.getUpdateValue(string);
            this._updator.setUpdateURL(string3);
        } else if (string.startsWith("UPDATE_CLASSPATH")) {
            String string4 = this.getUpdateValue(string);
            this._updator.setClassPath(string4);
        } else if (string.startsWith("UPDATE_MAIN_CLASS")) {
            String string5 = this.getUpdateValue(string);
            this._updator.setMainClass(string5);
        }
    }

    private final String getUpdateValue(String string) {
        int n = string.lastIndexOf("=") + 1;
        string = URLDecoder.decode(string.substring(n));
        return string.trim();
    }

    private final void setUpdator(String string) {
        int n = string.lastIndexOf("=") + 1;
        String string2 = URLDecoder.decode(string.substring(n));
        if (string2.startsWith("NO_UPDATE")) {
            this._updator = new NoUpdateUpdator();
        } else if (string2.startsWith("UPDATE_JAR")) {
            this._updator = new MultipleFileUpdator();
        } else if (string2.startsWith("OPEN_WEB_PAGE")) {
            this._updator = new WebPageUpdator();
        } else if (string2.startsWith("DISPLAY_MESSAGE")) {
            this._updator = new DisplayMessageUpdator();
        }
    }

    public String toString() {
        return "ClientRemoteUpdateInfo::Updator: " + this._updator.toString();
    }
}

