/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.AbstractRemoteUpdateInfo;
import com.limegroup.gnutella.update.ServletLocalUpdateInfo;
import java.io.IOException;
import java.net.URLEncoder;

public final class ServletRemoteUpdateInfo
extends AbstractRemoteUpdateInfo {
    private final String AD_URL = "http://version.limewire.com/updates/ads.war";
    private String _directive = "NO_UPDATE";
    private String _url = "";
    private String _message = "";
    private String _classpath = "";
    private String _mainClass = "";
    private final String[] IGNORE_LIST = new String[]{"@version@", "2.8.0", "2.8.0 Pro", "2.8.1", "2.8.1 Pro", "2.8.2", "2.8.2 Pro"};
    private static final String MAJOR_VERSION = "2";
    private static final String MINOR_VERSION = "7";
    private static final String BUILD_VERSION = "13";
    static final String LIMEWIRE_VERSION_ON_SERVER = "2.7.13";
    private static final String LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE = "2.7";
    private static final String UPDATE_JAR_NAME = "LimeWire2713.jar";
    private final String AD_VERSION_ON_SERVER = "1.1";
    private static final String FREE_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 2.7.13!  It includes remote queuing of uploads and resume of incomplete files from the library.  It is very important to upgrade to GWebCache versions of LimeWire.  Any versions prior to LimeWire 2.6 MUST be upgraded.  Update now?";
    private static final String STRONG_FREE_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 2.7.13!  ALL USERS OF LIMEWIRE VERSIONS PRIOR TO 2.6 MUST UPGRADE NOW!  THE NEW VERSIONS INCLUDE GWEBCACHE SUPPORT, WHICH IS REQUIRED TO CONNECT TO THE NETWORK!  UPDATE NOW?";
    private static final String PRO_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 2.7.13 Pro!  It includes remote queuing of uploads and resume of incomplete files from the library.  It is very important to upgrade to GWebCache versions of LimeWire.  Any versions prior to LimeWire 2.6 MUST be upgraded.  Update now?";
    private static final String STRONG_PRO_UPDATE_NOW_MESSAGE = "Upgrade to LimeWire 2.7.13 Pro!  ALL USERS OF LIMEWIRE VERSIONS PRIOR TO 2.6 MUST UPGRADE NOW!  THE NEW VERSIONS INCLUDE GWEBCACHE SUPPORT, WHICH IS REQUIRED TO CONNECT TO THE NETWORK!  UPDATE NOW?";
    private final String FREE_DISPLAY_MESSAGE_UPDATE_MESSAGE = "Version 2.7.13 of LimeWire is available from www.limewire.com. Would you like to start your old version now?";
    private final String PRO_DISPLAY_MESSAGE_UPDATE_MESSAGE = "Version 2.7.13 of LimeWire Pro is available, and you can access it from the web page that we sent you when you first purchased LimeWire Pro.  Would you like to start your old version now?";
    private final String MAIN_CLASS = "com.limegroup.gnutella.gui.Main";
    private static final String COLLECTIONS = "collections.jar";
    private static final String XERCES = "xerces.jar";
    private static final String PLAYER = "jl011.jar";
    private static final String MESSAGES = "MessagesBundles.jar";
    private static final String OLD_MESSAGES = "MessagesBundle.properties";
    private final String NON_WINDOWS_CLASSPATH = "LimeWire2713.jar";
    private final String WINDOWS_CLASSPATH = "LimeWire2713.jar";
    private final String WEB_FREE_UPDATE_URL = "http://www.limewire.com/index.jsp/download";
    private final String WEB_PRO_UPDATE_URL = "http://www.limewire.com/index.jsp/update";
    private static final String BASE_UPDATE_URL = "http://version.limewire.com/updates/";
    private static final String PRO_UPDATE_URL = "http://version.limewire.com/updates/pro/";
    private static final String FREE_UPDATE_URL = "http://version.limewire.com/updates/free/";
    private static final String MESSAGES_BUNDLE_URL = "http://version.limewire.com/updates/MessagesBundles.jar";
    private static final String OLD_MESSAGES_BUNDLE_URL = "http://version.limewire.com/updates/MessagesBundle.properties";
    private static final String XML_URL = "http://version.limewire.com/updates/xml.war";
    private static final String ADS_URL = "http://version.limewire.com/updates/ads.war";
    private final String PRO_JAR_UPDATE_URL = "http://version.limewire.com/updates/pro/LimeWire2713.jar;http://version.limewire.com/updates/MessagesBundles.jar;http://version.limewire.com/updates/xml.war;http://version.limewire.com/updates/MessagesBundle.properties";
    private final String FREE_JAR_UPDATE_URL = "http://version.limewire.com/updates/free/LimeWire2713.jar;http://version.limewire.com/updates/ads.war;http://version.limewire.com/updates/MessagesBundles.jar;http://version.limewire.com/updates/xml.war;http://version.limewire.com/updates/MessagesBundle.properties";

    private ServletRemoteUpdateInfo() {
    }

    public ServletRemoteUpdateInfo(ServletLocalUpdateInfo servletLocalUpdateInfo) throws IOException {
        String string = servletLocalUpdateInfo.getLimeWireVersion();
        String string2 = servletLocalUpdateInfo.getOS();
        if (string == null || string.equals("")) {
            throw new IOException("invalid version");
        }
        if (string2 == null || string2.equals("")) {
            throw new IOException("invalid operating system");
        }
        int n = 0;
        while (n < this.IGNORE_LIST.length) {
            if (string.endsWith(this.IGNORE_LIST[n])) {
                return;
            }
            ++n;
        }
        boolean bl = false;
        if (string.endsWith("Pro")) {
            bl = true;
        }
        string = string.substring(0, 3);
        if (!bl && !string.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
            this.setValuesForFreeVersionUpdate(string, string2);
        } else if (bl && !string.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
            this.setValuesForProVersionUpdate(string, string2);
        }
    }

    private void setValuesForAdUpdate(String string, String string2) {
        if (string.startsWith("1.")) {
            return;
        }
        this._directive = "UPDATE_ADS_STRING";
        this._url = ADS_URL;
    }

    private void setValuesForFreeVersionUpdate(String string, String string2) {
        if (string2.indexOf("Win") != -1) {
            this.setValuesForFreeWindowsUpdate(string);
        } else if (string2.indexOf("Sol") != -1) {
            this.setValuesForFreeOtherUpdate(string);
        } else if (string2.indexOf("Lin") != -1) {
            this.setValuesForFreeOtherUpdate(string);
        } else if (string2.startsWith("Mac")) {
            if (string2.endsWith("X")) {
                this.setValuesForFreeOSXUpdate(string);
            } else {
                this.setValuesForFreeMacUpdate(string);
            }
        } else {
            this.setValuesForFreeOtherUpdate(string);
        }
    }

    private void setValuesForProVersionUpdate(String string, String string2) {
        if (string2.indexOf("Win") != -1) {
            this.setValuesForProWindowsUpdate(string);
        } else if (string2.indexOf("Sol") != -1) {
            this.setValuesForProOtherUpdate(string);
        } else if (string2.indexOf("Lin") != -1) {
            this.setValuesForProOtherUpdate(string);
        } else if (string2.startsWith("Mac")) {
            if (string2.endsWith("X")) {
                this.setValuesForProOSXUpdate(string);
            } else {
                this.setValuesForProMacUpdate(string);
            }
        } else {
            this.setValuesForProOtherUpdate(string);
        }
    }

    public String getURLEncodedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DIRECTIVE");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._directive));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_URL");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._url));
        stringBuffer.append("&");
        stringBuffer.append("MESSAGE_TO_DISPLAY");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._message));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_CLASSPATH");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._classpath));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_MAIN_CLASS");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._mainClass));
        return stringBuffer.toString();
    }

    private void setValuesForProWindowsUpdate(String string) {
        this._directive = "OPEN_WEB_PAGE";
        this._url = "http://www.limewire.com/index.jsp/update";
        this._message = !string.startsWith("2.6") ? STRONG_PRO_UPDATE_NOW_MESSAGE : PRO_UPDATE_NOW_MESSAGE;
    }

    private void setValuesForProMacUpdate(String string) {
        this.setValuesForProWindowsUpdate(string);
    }

    private void setValuesForProOSXUpdate(String string) {
        this.setValuesForProWindowsUpdate(string);
    }

    private void setValuesForProOtherUpdate(String string) {
        this._directive = "DISPLAY_MESSAGE";
        this._message = "Version 2.7.13 of LimeWire Pro is available, and you can access it from the web page that we sent you when you first purchased LimeWire Pro.  Would you like to start your old version now?";
    }

    private void setValuesForFreeWindowsUpdate(String string) {
        this._directive = "OPEN_WEB_PAGE";
        this._url = "http://www.limewire.com/index.jsp/download";
        this._message = !string.startsWith("2.6") ? STRONG_FREE_UPDATE_NOW_MESSAGE : FREE_UPDATE_NOW_MESSAGE;
    }

    private void setValuesForFreeMacUpdate(String string) {
        this.setValuesForFreeWindowsUpdate(string);
    }

    private void setValuesForFreeOSXUpdate(String string) {
        this.setValuesForFreeWindowsUpdate(string);
    }

    private void setValuesForFreeOtherUpdate(String string) {
        this._directive = "DISPLAY_MESSAGE";
        this._message = "Version 2.7.13 of LimeWire is available from www.limewire.com. Would you like to start your old version now?";
    }

    public String toString() {
        return "ServletRemoteUpdateInfo\r\ndirective:  " + this._directive + "\r\n" + "url:        " + this._url + "\r\n" + "message:    " + this._message + "\r\n" + "classpath:  " + this._classpath + "\r\n" + "main class: " + this._mainClass;
    }

    public static void main(String[] stringArray) {
        ServletRemoteUpdateInfo servletRemoteUpdateInfo = new ServletRemoteUpdateInfo();
        String string = "Windows";
        String[] stringArray2 = new String[]{"2.7.13 Pro", LIMEWIRE_VERSION_ON_SERVER, "2.6.5"};
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            boolean bl = false;
            if (string2.endsWith("Pro")) {
                bl = true;
            }
            string2 = string2.substring(0, 3);
            System.out.println("version: " + string2);
            if (!bl && !string2.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
                System.out.println("about to set free update");
                servletRemoteUpdateInfo.setValuesForFreeVersionUpdate(string2, string);
            } else if (bl && !string2.equals(LIMEWIRE_VERSION_ON_SERVER_TO_COMPARE)) {
                System.out.println("about to set pro update");
                servletRemoteUpdateInfo.setValuesForProVersionUpdate(string2, string);
            }
            ++n;
        }
    }
}

