/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update.gui;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

final class UpdatePanel {
    private final JDialog DIALOG;
    private int _responseCode;
    static final int UPDATE_LATER = 10;
    static final int UPDATE_NOW = 11;

    static UpdatePanel createUpdatePanelWithParentFrame(String string) {
        return new UpdatePanel(string, true);
    }

    static UpdatePanel createFloatingUpdatePanel(String string) {
        return new UpdatePanel(string, false);
    }

    private UpdatePanel(String string, boolean bl) {
        this.DIALOG = bl ? new JDialog(GUIMediator.getAppFrame()) : new JDialog();
        this.DIALOG.setModal(true);
        this.DIALOG.setTitle(GUIMediator.getStringResource("UPDATE_DIALOG_CAPTION"));
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, 320);
        String[] stringArray = new String[]{"YES", "NO"};
        String[] stringArray2 = new String[]{"UPDATE_NOW_TIP", "UPDATE_LATER_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new UpdateNowListener(), new UpdateLaterListener()};
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add(multiLineLabel);
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray);
        Container container = this.DIALOG.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(jPanel);
        container.add(Box.createVerticalGlue());
        container.add(buttonRow);
        this.DIALOG.pack();
    }

    int showDialog() {
        ((Component)this.DIALOG).setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        ((Component)this.DIALOG).setVisible(true);
        return this._responseCode;
    }

    private final class UpdateLaterListener
    implements ActionListener {
        private UpdateLaterListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UpdatePanel.this._responseCode = 10;
            ((Component)UpdatePanel.this.DIALOG).setVisible(false);
            UpdatePanel.this.DIALOG.dispose();
        }
    }

    private final class UpdateNowListener
    implements ActionListener {
        private UpdateNowListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UpdatePanel.this._responseCode = 11;
            ((Component)UpdatePanel.this.DIALOG).setVisible(false);
            UpdatePanel.this.DIALOG.dispose();
        }
    }
}

