/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UpdateFileParser {
    private static DOMParser parser = new DOMParser();
    private String newVersion = null;
    private String updateMessage = null;
    private boolean usingLocale = true;

    public UpdateFileParser(String string) throws SAXException, IOException {
        if (string == null || string.equals("")) {
            throw new SAXException(new Exception());
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = null;
        DOMParser dOMParser = parser;
        synchronized (dOMParser) {
            parser.parse(inputSource);
            document = parser.getDocument();
        }
        if (document == null) {
            throw new SAXException(new Exception());
        }
        this.populateValues(document);
    }

    private void populateValues(Document document) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            String string = node.getNodeName().toLowerCase().trim();
            if (string.equals("version")) {
                this.newVersion = LimeXMLUtils.getText(node.getChildNodes());
            } else if (string.equals("message")) {
                this.updateMessage = this.getLocaleSpecificMessage(node);
            }
            ++n2;
        }
    }

    private String getLocaleSpecificMessage(Node node) {
        String string = SettingsManager.instance().getLanguage().toLowerCase();
        String string2 = null;
        String string3 = null;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            String string4 = node2.getNodeName().toLowerCase().trim();
            if (string4.equals("en")) {
                string2 = LimeXMLUtils.getText(node2.getChildNodes());
            } else if (string4.equals(string)) {
                string3 = LimeXMLUtils.getText(node2.getChildNodes());
            }
            ++n2;
        }
        Assert.that(string2 != null, "bad xml file signed by LimeWire");
        if (string.equals("en")) {
            return string2;
        }
        if (string3 != null) {
            return string3;
        }
        this.usingLocale = false;
        return string2;
    }

    public String getVersion() {
        return this.newVersion;
    }

    public boolean usesLocale() {
        return this.usingLocale;
    }

    public String getMessage() {
        return this.updateMessage;
    }
}

