/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.updates.UpdateFileParser;
import com.limegroup.gnutella.updates.UpdateMessageVerifier;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.StringTokenizer;

public class UpdateManager {
    private String latestVersion;
    private String message = "";
    private boolean usesLocale;
    private static UpdateManager INSTANCE = null;
    private boolean debug = false;

    private UpdateManager() {
        try {
            File file = new File(CommonUtils.getUserSettingsDir(), "update.xml");
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
            UpdateMessageVerifier updateMessageVerifier = new UpdateMessageVerifier(byArray);
            boolean bl = updateMessageVerifier.verifySource();
            if (!bl) {
                this.latestVersion = CommonUtils.getLimeWireVersion();
                return;
            }
            String string = new String(updateMessageVerifier.getMessageBytes(), "UTF-8");
            UpdateFileParser updateFileParser = new UpdateFileParser(string);
            this.latestVersion = updateFileParser.getVersion();
            this.message = updateFileParser.getMessage();
            this.usesLocale = updateFileParser.usesLocale();
        }
        catch (Exception exception) {
            this.latestVersion = CommonUtils.getLimeWireVersion();
        }
    }

    public static synchronized UpdateManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    public synchronized String getVersion() {
        Assert.that(this.latestVersion != null, "version not initilaized");
        return this.latestVersion;
    }

    public void postGuiInit(ActivityCallback activityCallback) {
        String string = CommonUtils.getLimeWireVersion();
        if (string.equalsIgnoreCase(this.latestVersion)) {
            return;
        }
        if (!UpdateManager.isGreaterVersion(this.latestVersion, string)) {
            return;
        }
        String string2 = this.latestVersion + ". " + this.message;
        activityCallback.notifyUserAboutUpdate(string2, CommonUtils.isPro(), this.usesLocale);
    }

    public void checkAndUpdate(Connection connection) {
        String string = connection.getProperty("X-Version");
        this.debug("myVersion:" + this.latestVersion + " theirs: " + string);
        if (!UpdateManager.isGreaterVersion(string, this.latestVersion)) {
            return;
        }
        final Connection connection2 = connection;
        Thread thread = new Thread(){

            public void run() {
                block8: {
                    UpdateManager.this.debug("Getting update file");
                    String string = connection2.getOrigHost();
                    int n = connection2.getOrigPort();
                    byte[] byArray = null;
                    try {
                        int n2;
                        URL uRL = new URL("HTTP", string, n, "/update.xml");
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setUseCaches(false);
                        httpURLConnection.setRequestProperty("User-Agent", CommonUtils.getHttpServer());
                        httpURLConnection.setRequestProperty(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                        httpURLConnection.setRequestProperty("accept", "text/html");
                        InputStream inputStream = httpURLConnection.getInputStream();
                        int n3 = httpURLConnection.getContentLength();
                        UpdateManager.this.debug("Content len " + n3);
                        byArray = new byte[n3];
                        int n4 = 1024;
                        byte[] byArray2 = new byte[n4];
                        int n5 = n3 % n4 == 0 ? n3 / n4 : n3 / n4 + 1;
                        ByteReader byteReader = new ByteReader(inputStream);
                        int n6 = 0;
                        int n7 = 0;
                        while (n7 < n5) {
                            int n8 = n3 - n6;
                            n2 = byteReader.read(byArray2, 0, Math.min(n4, n8));
                            if (n2 == -1) break;
                            System.arraycopy(byArray2, 0, byArray, n6, n2);
                            n6 += n2;
                            ++n7;
                        }
                        UpdateMessageVerifier updateMessageVerifier = new UpdateMessageVerifier(byArray);
                        n2 = updateMessageVerifier.verifySource();
                        if (n2 == 0) {
                            UpdateManager.this.debug("Verification failed");
                            return;
                        }
                        UpdateManager.this.debug("Verified file contents");
                        String string2 = new String(updateMessageVerifier.getMessageBytes(), "UTF-8");
                        UpdateFileParser updateFileParser = new UpdateFileParser(string2);
                        UpdateManager.this.debug("New version: " + updateFileParser.getVersion());
                        String string3 = updateFileParser.getVersion();
                        if (string3 == null) {
                            return;
                        }
                        if (!UpdateManager.isGreaterVersion(string3, UpdateManager.this.latestVersion)) break block8;
                        UpdateManager.this.debug("committing new update file");
                        UpdateManager updateManager = UpdateManager.this;
                        synchronized (updateManager) {
                            UpdateManager.this.commitVersionFile(byArray);
                            UpdateManager.this.latestVersion = string3;
                            UpdateManager.this.debug("commited file. Latest is:" + UpdateManager.this.latestVersion);
                        }
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
        };
        thread.start();
    }

    public static boolean isGreaterVersion(String string, String string2) {
        int n;
        int n2;
        if (string == null && string2 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return true;
        }
        if (string.equals(string2)) {
            return false;
        }
        if (string.equals("@version@")) {
            return true;
        }
        if (string2.equals("@version@")) {
            return false;
        }
        int n3 = -1;
        int n4 = -1;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            n2 = new Integer(stringTokenizer.nextToken());
            n3 = new Integer(stringTokenizer.nextToken());
            stringTokenizer = new StringTokenizer(string, ".");
            n = new Integer(stringTokenizer.nextToken());
            n4 = new Integer(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return false;
        }
        if (n > n2) {
            return true;
        }
        return n == n2 && n4 > n3;
    }

    private void commitVersionFile(byte[] byArray) throws IOException {
        File file = new File(CommonUtils.getUserSettingsDir(), "update.xml");
        File file2 = new File(CommonUtils.getUserSettingsDir(), "update.new");
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        randomAccessFile.write(byArray);
        randomAccessFile.close();
        boolean bl = file.delete();
        if (bl) {
            boolean bl2 = file2.renameTo(file);
            if (!bl2) {
                file2.delete();
                throw new IOException();
            }
        } else {
            file2.delete();
            throw new IOException();
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }
}

