/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.updates;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

public class UpdateMessageVerifier {
    private byte[] data;
    private byte[] signature;
    private byte[] xmlMessage;

    public UpdateMessageVerifier(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this.data = byArray;
    }

    public boolean verifySource() {
        Object object;
        this.parse();
        PublicKey publicKey = null;
        try {
            object = new File(CommonUtils.getUserSettingsDir(), "public.key");
            FileInputStream fileInputStream = new FileInputStream((File)object);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            publicKey = (PublicKey)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            object = Signature.getInstance("DSA");
            ((Signature)object).initVerify(publicKey);
            ((Signature)object).update(this.xmlMessage, 0, this.xmlMessage.length);
            return ((Signature)object).verify(this.signature);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }

    private void parse() {
        int n = 0;
        int n2 = -1;
        while (n2 != 124) {
            n2 = this.data[n];
            ++n;
        }
        int n3 = --n + 1;
        n2 = -1;
        while (n2 != 124) {
            n2 = this.data[n3];
            ++n3;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 0, byArray, 0, n);
        String string = new String(byArray);
        this.signature = Base32.decode(string);
        this.xmlMessage = new byte[this.data.length - 1 - --n3];
        System.arraycopy(this.data, n3 + 1, this.xmlMessage, 0, this.data.length - 1 - n3);
    }

    public byte[] getMessageBytes() throws IllegalStateException {
        if (this.xmlMessage == null) {
            throw new IllegalStateException();
        }
        return this.xmlMessage;
    }

    public static void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(new File(new File("lib"), "update.xml"), "r");
            byte[] byArray = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(byArray);
            randomAccessFile.close();
            UpdateMessageVerifier updateMessageVerifier = new UpdateMessageVerifier(byArray);
            boolean bl = updateMessageVerifier.verifySource();
            System.out.println("" + bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Failed");
        }
    }
}

