/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class BrowseHostUploadState
implements HTTPMessage {
    private final HTTPUploader _uploader;
    private final ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
    private static final boolean debugOn = false;

    public BrowseHostUploadState(HTTPUploader hTTPUploader) {
        this._uploader = hTTPUploader;
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        Object object;
        if (!this._uploader.getClientAcceptsXGnutellaQueryreplies()) {
            String string = "HTTP/1.1 406 Not Acceptable\r\n";
            outputStream.write(string.getBytes());
            outputStream.flush();
            this.debug("BHUS.doUpload(): client does not accept QRs.");
            return;
        }
        QueryRequest queryRequest = new QueryRequest(1, 0, "    ", false);
        Response[] responseArray = RouterService.getFileManager().query(queryRequest);
        if (responseArray == null) {
            responseArray = new Response[]{};
        }
        Iterator iterator = RouterService.getMessageRouter().responsesToQueryReplies(responseArray, queryRequest);
        try {
            while (iterator.hasNext()) {
                object = (QueryReply)iterator.next();
                ((Message)object).write(this.BAOS);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = "HTTP/1.1 200 OK\r\n";
        outputStream.write(((String)object).getBytes());
        object = "User-Agent: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(((String)object).getBytes());
        object = "Content-Type: application/x-gnutella-packets\r\n";
        outputStream.write(((String)object).getBytes());
        object = "Content-Length: " + this.BAOS.size() + "\r\n";
        outputStream.write(((String)object).getBytes());
        object = "\r\n";
        outputStream.write(((String)object).getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        outputStream.write(this.BAOS.toByteArray());
        this._uploader.setAmountUploaded(this.BAOS.size());
        this._uploader.setState(4);
        this.debug("BHUS.doUpload(): returning.");
    }

    public boolean getCloseConnection() {
        return true;
    }

    private final void debug(String string) {
    }

    private final void debug(Exception exception) {
    }
}

