/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollection;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.uploader.BrowseHostUploadState;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushFailedUploadState;
import com.limegroup.gnutella.uploader.QueuedUploadState;
import com.limegroup.gnutella.uploader.UpdateFileState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

public final class HTTPUploader
implements Uploader {
    private OutputStream _ostream;
    private InputStream _fis;
    private Socket _socket;
    private int _amountRead;
    private int _amountRequested;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _fileSize;
    private final int _index;
    private String _userAgent;
    private boolean _headersParsed;
    private final String _fileName;
    private final String _hostName;
    private final String _guid;
    private final int _port;
    private int _stateNum = 0;
    private HTTPMessage _state;
    private boolean _chatEnabled;
    private boolean _browseEnabled;
    private int _gnutellaPort;
    private boolean _supportsQueueing = false;
    private URN _requestedURN;
    private FileDesc _fileDesc;
    private boolean _clientAcceptsXGnutellaQueryreplies = false;
    private BandwidthTrackerImpl bandwidthTracker = null;
    private AlternateLocationCollection _alternateLocationCollection;
    private HTTPRequestMethod _method;
    private final boolean debugOn = false;

    public HTTPUploader(HTTPRequestMethod hTTPRequestMethod, String string, Socket socket, int n, HTTPUploader hTTPUploader) {
        this._method = hTTPRequestMethod;
        this._socket = socket;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._fileName = string;
        this._index = n;
        this._amountRead = 0;
        this._guid = null;
        this._port = 0;
        this.bandwidthTracker = hTTPUploader != null ? hTTPUploader.bandwidthTracker : new BandwidthTrackerImpl();
        try {
            this._ostream = this._socket.getOutputStream();
            if (n == -1) {
                this.setState(8);
                return;
            }
            if (n == -2) {
                this.setState(10);
                return;
            }
            this._fileDesc = RouterService.getFileManager().get(this._index);
            this._fileSize = (int)this._fileDesc.getSize();
            if (!this._fileName.equals(this._fileDesc.getName())) {
                this.setState(7);
            } else {
                this._fis = this._fileDesc.createInputStream();
                this.setState(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setState(7);
        }
        catch (IOException iOException) {
            this.setState(7);
        }
    }

    public HTTPUploader(String string, String string2, int n, int n2, String string3) {
        this._fileName = string;
        this._index = n2;
        this._uploadBegin = 0;
        this._amountRead = 0;
        this._hostName = string2;
        this._guid = string3;
        this._port = n;
        try {
            this._fileDesc = RouterService.getFileManager().get(this._index);
            this._fileSize = (int)this._fileDesc.getSize();
            if (!this._fileName.equals(this._fileDesc.getName())) {
                this.setState(7);
            } else {
                this._fis = this._fileDesc.createInputStream();
                this.setState(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setState(6);
        }
        catch (IOException iOException) {
            this.setState(7);
        }
    }

    public Socket connect() throws IOException {
        if (this._socket != null) {
            return this._socket;
        }
        try {
            this._socket = new Socket(this._hostName, this._port);
            this._ostream = this._socket.getOutputStream();
            Assert.that(this._fileName != null);
            Assert.that(this._fileName != "");
            String string = "GIV " + this._index + ":" + this._guid + "/" + this._fileName + "\n\n";
            this._ostream.write(string.getBytes());
            this._ostream.flush();
            return this._socket;
        }
        catch (SecurityException securityException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setState(6);
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IOException iOException) {
            this.setState(6);
            throw new IOException();
        }
    }

    public void writeResponse() {
        try {
            if (this._ostream != null) {
                this._method.writeHttpResponse(this._state, this._ostream);
            }
        }
        catch (FreeloaderUploadingException freeloaderUploadingException) {
            this.setState(1);
            try {
                if (this._ostream != null) {
                    this._method.writeHttpResponse(this._state, this._ostream);
                }
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            if (this._amountRead >= this._amountRequested) {
                this.setState(4);
            }
            this.setState(5);
        }
        if (this._alternateLocationCollection != null && this._fileDesc != null) {
            this._fileDesc.addAlternateLocationCollection(this._alternateLocationCollection);
        }
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setState(int n) {
        this._stateNum = n;
        switch (n) {
            case 0: {
                this._state = new NormalUploadState(this);
                break;
            }
            case 9: {
                int n2 = RouterService.getUploadManager().positionInQueue(this._socket);
                this._state = new QueuedUploadState(n2, this._fileDesc);
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState(this._fileDesc);
                break;
            }
            case 6: {
                this._state = new PushFailedUploadState();
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 8: {
                this._state = new BrowseHostUploadState(this);
                break;
            }
            case 10: {
                this._state = new UpdateFileState(this);
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
            }
        }
    }

    OutputStream getOutputStream() {
        return this._ostream;
    }

    InputStream getInputStream() {
        return this._fis;
    }

    void setAmountUploaded(int n) {
        int n2 = n - this._amountRead;
        if (n2 > 0 && !CommonUtils.isJava118()) {
            BandwidthStat.HTTP_BODY_UPSTREAM_BANDWIDTH.addData(n2);
        }
        this._amountRead = n;
    }

    int getUploadBegin() {
        return this._uploadBegin;
    }

    int getUploadEnd() {
        return this._uploadEnd;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public int getAmountRequested() {
        return this._amountRequested;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._fileName;
    }

    public int getState() {
        return this._stateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public boolean isChatEnabled() {
        return this._chatEnabled;
    }

    public boolean isBrowseHostEnabled() {
        return this._browseEnabled;
    }

    public int getGnutellaPort() {
        return this._gnutellaPort;
    }

    public String getUserAgent() {
        return this._userAgent;
    }

    public boolean isHeaderParsed() {
        return this._headersParsed;
    }

    public boolean supportsQueueing() {
        return this._supportsQueueing;
    }

    public int amountUploaded() {
        return this._amountRead;
    }

    public FileDesc getFileDesc() {
        return this._fileDesc;
    }

    boolean getClientAcceptsXGnutellaQueryreplies() {
        return this._clientAcceptsXGnutellaQueryreplies;
    }

    public void readHeader() throws IOException {
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        this._clientAcceptsXGnutellaQueryreplies = false;
        ByteReader byteReader = new ByteReader(this._socket.getInputStream());
        try {
            String string;
            while ((string = byteReader.readLine()) != null && !string.equals("")) {
                if (!CommonUtils.isJava118()) {
                    BandwidthStat.HTTP_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
                }
                this.debug("HTTPUploader.readHeader(): str = " + string);
                if (this.readChatHeader(string) || this.readRangeHeader(string) || this.readUserAgentHeader(string) || this.readContentURNHeader(string) || this.readAltLocationHeader(string) || this.readAcceptHeader(string) || !this.readQueueVersion(string)) continue;
            }
            Object var4_3 = null;
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this._uploadEnd <= 0 || this._uploadEnd <= this._uploadBegin || this._uploadEnd > this._fileSize) {
                this._uploadEnd = this._fileSize;
            }
            this._amountRequested = this._uploadEnd - this._uploadBegin;
            this._headersParsed = true;
            throw throwable;
        }
    }

    private boolean readChatHeader(String string) throws IOException {
        int n;
        String string2;
        if (string.toUpperCase().indexOf("CHAT:") == -1) {
            return false;
        }
        try {
            string2 = string.substring(5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        string2 = string2.trim();
        int n2 = string2.indexOf(":");
        String string3 = string2.substring(0, n2);
        string3 = string3.trim();
        String string4 = string2.substring(n2 + 1);
        string4 = string4.trim();
        try {
            n = Integer.parseInt(string4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        this._chatEnabled = true;
        this._browseEnabled = true;
        this._gnutellaPort = n;
        return true;
    }

    private boolean readRangeHeader(String string) throws IOException {
        String string2;
        String string3;
        String string4;
        int n;
        if (this.indexOfIgnoreCase(string, "Range:") == -1) {
            return false;
        }
        try {
            n = string.indexOf("bytes");
            if (n < 0) {
                throw new IOException();
            }
            string4 = string.substring(n += 6);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        string4 = string4.trim();
        try {
            n = string4.charAt(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        if (n == 45) {
            String string5;
            try {
                string5 = string4.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IOException();
            }
            string5 = string5.trim();
            try {
                this._uploadBegin = Math.max(0, this._fileSize - Integer.parseInt(string5));
                this._uploadEnd = this._fileSize;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException();
            }
        }
        int n2 = string4.indexOf("-");
        try {
            string3 = string4.substring(0, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        string3 = string3.trim();
        try {
            this._uploadBegin = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
        try {
            string2 = string4.substring(n2 + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        string2 = string2.trim();
        if (!string2.equals("")) {
            try {
                this._uploadEnd = Integer.parseInt(string2) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException();
            }
        }
        return true;
    }

    private boolean readUserAgentHeader(String string) throws FreeloaderUploadingException {
        if (this.indexOfIgnoreCase(string, "User-Agent:") == -1) {
            return false;
        }
        if (!(SettingsManager.instance().getAllowBrowser() || this._stateNum == 8 || this._fileName.toUpperCase().startsWith("LIMEWIRE") || string.indexOf("Mozilla") == -1 && string.indexOf("DA") == -1 && string.indexOf("Download") == -1 && string.indexOf("FlashGet") == -1 && string.indexOf("GetRight") == -1 && string.indexOf("Go!Zilla") == -1 && string.indexOf("Inet") == -1 && string.indexOf("MIIxpc") == -1 && string.indexOf("MSProxy") == -1 && string.indexOf("Mass") == -1 && string.indexOf("MyGetRight") == -1 && string.indexOf("NetAnts") == -1 && string.indexOf("NetZip") == -1 && string.indexOf("RealDownload") == -1 && string.indexOf("SmartDownload") == -1 && string.indexOf("Teleport") == -1 && string.indexOf("WebDownloader") == -1)) {
            throw new FreeloaderUploadingException();
        }
        this._userAgent = string.substring(11).trim();
        return true;
    }

    private boolean readContentURNHeader(String string) {
        if (!HTTPHeaderName.GNUTELLA_CONTENT_URN.matchesStartOfString(string)) {
            return false;
        }
        URN uRN = HTTPUploader.parseContentUrn(string);
        if (uRN == null) {
            this.setState(7);
        } else if (this._fileDesc != null && !this._fileDesc.containsUrn(uRN)) {
            this.setState(7);
        }
        return true;
    }

    private boolean readAltLocationHeader(String string) {
        if (!HTTPHeaderName.ALT_LOCATION.matchesStartOfString(string)) {
            return false;
        }
        if (this._alternateLocationCollection == null) {
            this._alternateLocationCollection = new AlternateLocationCollection();
        }
        HTTPUploader.parseAlternateLocations(string, this._alternateLocationCollection);
        return true;
    }

    private boolean readAcceptHeader(String string) {
        if (this.indexOfIgnoreCase(string, "accept:") == -1) {
            return false;
        }
        if (this.indexOfIgnoreCase(string, "application/x-gnutella-packets") != -1) {
            this._clientAcceptsXGnutellaQueryreplies = true;
        }
        return true;
    }

    private boolean readQueueVersion(String string) {
        if (!HTTPHeaderName.QUEUE_HEADER.matchesStartOfString(string)) {
            return false;
        }
        this._supportsQueueing = true;
        return true;
    }

    private static URN parseContentUrn(String string) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return null;
        }
        try {
            return URN.createSHA1Urn(string2);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static void parseAlternateLocations(String string, AlternateLocationCollector alternateLocationCollector) {
        String string2 = HTTPUtils.extractHeaderValue(string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                AlternateLocation alternateLocation = AlternateLocation.createAlternateLocation(stringTokenizer.nextToken().trim());
                alternateLocationCollector.addAlternateLocation(alternateLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int indexOfIgnoreCase(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.indexOf(string4);
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.amountUploaded());
    }

    public float getMeasuredBandwidth() {
        float f = 0.0f;
        try {
            f = this.bandwidthTracker.getMeasuredBandwidth();
        }
        catch (InsufficientDataException insufficientDataException) {
            f = 0.0f;
        }
        return f;
    }

    public float getAverageBandwidth() {
        return this.bandwidthTracker.getAverageBandwidth();
    }

    public boolean getCloseConnection() {
        return this._state.getCloseConnection();
    }

    private void debug(String string) {
    }

    public String toString() {
        return "<" + this._hostName + ":" + this._port + ", " + this._fileName + ">";
    }
}

