/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.OutputStream;

public class LimitReachedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();

    public LimitReachedUploadState(FileDesc fileDesc) {
        this.FILE_DESC = fileDesc;
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        URN uRN;
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Type: text/plain\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: " + this.ERROR_MESSAGE.length + "\r\n";
        outputStream.write(string.getBytes());
        if (this.FILE_DESC != null && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, outputStream);
            if (this.FILE_DESC.hasAlternateLocations()) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this.FILE_DESC.getAlternateLocationCollection(), outputStream);
            }
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        outputStream.write(this.ERROR_MESSAGE);
    }

    public boolean getCloseConnection() {
        return true;
    }
}

