/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public final class NormalUploadState
implements HTTPMessage {
    public static final int CYCLE_TIME = 1000;
    private final HTTPUploader _uploader;
    private final int _index;
    private final String _fileName;
    private final int _fileSize;
    private InputStream _fis;
    private int _amountRead;
    private int _uploadBegin;
    private int _uploadEnd;
    private int _amountRequested;
    private final FileDesc _fileDesc;
    private boolean _closeConnection = false;
    private final String MIME_TYPE = "application/binary";

    public NormalUploadState(HTTPUploader hTTPUploader) {
        this._uploader = hTTPUploader;
        this._fileDesc = this._uploader.getFileDesc();
        this._index = this._uploader.getIndex();
        this._fileName = this._uploader.getFileName();
        this._fileSize = this._uploader.getFileSize();
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        try {
            this._uploader.setState(3);
            this._fis = this._uploader.getInputStream();
            this._amountRead = this._uploader.amountUploaded();
            this._uploadBegin = this._uploader.getUploadBegin();
            this._uploadEnd = this._uploader.getUploadEnd();
            this._amountRequested = this._uploader.getAmountRequested();
            if (this._fileSize < this._uploadBegin) {
                throw new IOException("Invalid Range");
            }
            String string = this._uploadBegin == 0 && this._amountRequested == this._fileSize ? "HTTP/1.1 200 OK\r\n" : "HTTP/1.1 206 Partial Content\r\n";
            outputStream.write(string.getBytes());
            string = "Server: " + CommonUtils.getHttpServer() + "\r\n";
            outputStream.write(string.getBytes());
            String string2 = this.getMimeType();
            string = "Content-Type: " + string2 + "\r\n";
            outputStream.write(string.getBytes());
            string = "Content-Length: " + this._amountRequested + "\r\n";
            outputStream.write(string.getBytes());
            if (this._uploadBegin != 0) {
                string = "Content-Range: bytes " + this._uploadBegin + "-" + (this._uploadEnd - 1) + "/" + this._fileSize + "\r\n";
                outputStream.write(string.getBytes());
            }
            if (this._fileDesc != null) {
                URN uRN = this._fileDesc.getSHA1Urn();
                if (uRN != null) {
                    HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)uRN, outputStream);
                }
                if (this._fileDesc.hasAlternateLocations()) {
                    HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this._fileDesc.getAlternateLocationCollection(), outputStream);
                }
            }
            string = "\r\n";
            outputStream.write(string.getBytes());
            this._uploader.setState(4);
        }
        catch (IOException iOException) {
            this._closeConnection = true;
            throw iOException;
        }
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
        try {
            this._uploader.setState(3);
            int n = -1;
            byte[] byArray = new byte[1024];
            long l = this._fis.skip(this._uploadBegin);
            SettingsManager settingsManager = SettingsManager.instance();
            int n2 = settingsManager.getUploadSpeed();
            if (n2 == 100) {
                this.uploadUnthrottled(outputStream);
            }
            this.uploadThrottled(outputStream);
        }
        catch (IOException iOException) {
            this._closeConnection = true;
            throw iOException;
        }
        this._uploader.setState(4);
    }

    private void uploadUnthrottled(OutputStream outputStream) throws IOException {
        int n = -1;
        byte[] byArray = new byte[1024];
        while ((n = this._fis.read(byArray)) != -1) {
            if (n > this._amountRequested - this._amountRead) {
                n = this._amountRequested - this._amountRead;
            }
            try {
                outputStream.write(byArray, 0, n);
            }
            catch (SocketException socketException) {
                throw new IOException();
            }
            this._amountRead += n;
            this._uploader.setAmountUploaded(this._amountRead);
            if (this._amountRead < this._amountRequested) continue;
            break;
        }
    }

    private void uploadThrottled(OutputStream outputStream) throws IOException {
        while (true) {
            int n = RouterService.getUploadManager().calculateBandwidth();
            int n2 = n * 1000;
            int n3 = -1;
            byte[] byArray = new byte[1024];
            long l = System.currentTimeMillis();
            for (int i = 0; i < n2; i += n3) {
                n3 = this._fis.read(byArray);
                if (n3 == -1) {
                    return;
                }
                if (n3 > this._amountRequested - this._amountRead) {
                    n3 = this._amountRequested - this._amountRead;
                }
                try {
                    outputStream.write(byArray, 0, n3);
                }
                catch (SocketException socketException) {
                    throw new IOException();
                }
                this._amountRead += n3;
                this._uploader.setAmountUploaded(this._amountRead);
                if (this._amountRead < this._amountRequested) continue;
                return;
            }
            long l2 = System.currentTimeMillis();
            int n4 = (int)(l2 - l);
            int n5 = 1000 - n4;
            if (n5 <= 0) continue;
            try {
                Thread.currentThread();
                Thread.sleep(n5);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException();
            }
        }
    }

    private String getMimeType() {
        return "application/binary";
    }

    public boolean getCloseConnection() {
        return this._closeConnection;
    }

    public String toString() {
        return "NormalUploadState:\r\nFile Name:  " + this._fileName + "\r\n" + "File Size:  " + this._fileSize + "\r\n" + "File Index: " + this._index + "\r\n" + "File Desc:  " + this._fileDesc;
    }
}

