/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
implements HTTPMessage {
    private boolean closeConnection = false;
    private FileDesc FILE_DESC;
    private int position;
    private final byte[] ERROR_MESSAGE = "Server busy.  Too many active uploads.".getBytes();

    public QueuedUploadState(int n, FileDesc fileDesc) {
        this.position = n;
        this.FILE_DESC = fileDesc;
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        URN uRN;
        Assert.that(this.position != -1);
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        string = "X-Queue: position=" + (this.position + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        outputStream.write(string.getBytes());
        if (this.FILE_DESC != null && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), outputStream);
            if (this.FILE_DESC.hasAlternateLocations()) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)this.FILE_DESC.getAlternateLocationCollection(), outputStream);
            }
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
    }

    public boolean getCloseConnection() {
        return this.closeConnection;
    }
}

